% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-Deb.R
\name{DEB_abj}
\alias{DEB_abj}
\alias{DebAbj-class}
\title{DEB_abj}
\usage{
DEB_abj()
}
\value{
an S4 object of type \linkS4class{DebAbj}
}
\description{
Creates a \emph{DEB abj} scenario. The \emph{abj} model with type M acceleration is
like model \emph{std}, but acceleration occurs between birth and metamorphosis (V1-morph).
Isomorphy is assumed before and after acceleration. Metamorphosis is before
puberty and occurs at maturity \code{E_Hj}, which might or might not correspond with
changes in morphology. The \emph{abj} model is a one-parameter extension of model \emph{std}
\href{https://debportal.debtheory.org/docs/Typified_models.html}{(DEB Wiki)}.
}
\details{
\subsection{State variables}{

The following list describes the default names and standard units of the model's
state variables:
\itemize{
\item \code{L}, structural length (cm)
\item \code{E}, energy reserve (J)
\item \code{H}, energy invested in maturity (J)
\item \code{R}, reproduction buffer (J)
\item \code{cV}, internal concentration (\link{C})
\item \code{Lmax}, maximum structural length (cm)
}

All state variables are initialized with zero. See \code{\link[=set_init]{set_init()}} on how to set
the initial state.
}

\subsection{Parameters}{

The following model parameters are required:
\itemize{
\item \code{p_M}, vol-spec somatic maintenance (J/d.cm^3)
\item \code{v}, energy conductance (cm/d)
\item \code{k_J}, maturity maint rate coefficient (1/d)
\item \code{p_Am}, surface-area specific maximum assimilation rate (J/d.cm^2)
\item \code{kap}, allocation fraction to soma (-)
\item \code{E_G}, spec cost for structure (J/cm^3)
\item \code{f}, scaled functional response (-)
\item \code{E_Hj}, maturity at metamorphosis (J)
\item \code{E_Hp}, maturity at puberty (J)
\item \code{kap_R}, reproduction efficiency (-)
\item \code{L_b}, structural length at birth (cm)
\item \code{L_j}, structural length at metamorphosis (cm)
\item \code{ke}, elimination rate constant (d-1)
\item \code{c0}, no-effect concentration sub-lethal (\link{C})
\item \code{cT}, tolerance concentration (\link{C})
\item \code{MoA}, mode of action switch (-)
}
}

\subsection{Mode of Actions}{

Any combination of the following mode of actions (MoA) can be considered by
the model:
\itemize{
\item \code{MoA = 1}: effect on feeding
\item \code{MoA = 2}: effect on maintenance costs
\item \code{MoA = 4}: effect on overhead costs for making an egg
\item \code{MoA = 8}: hazard during oogenesis
\item \code{MoA = 16}: energy conductance
}

To activate more than one MoA, simply add up the corresponding
codes. To disable all MoAs, set the parameter to zero.
See also \code{\link[=set_mode_of_action]{set_mode_of_action()}}.
}

\subsection{Effects}{

The state variables \emph{L} (structural length) and \emph{R} (reproduction buffer) are
set as effect endpoints by default. All state variables are available as
potential endpoints. The list of considered endpoints can be modified
by using \code{\link[=set_endpoints]{set_endpoints()}}.

To calculate effects, each \emph{DEB} scenario is simulated twice: One simulation
which considers exposure to a toxicant and one simulation without exposure, i.e.
a control. See also \code{\link[=effect]{effect()}}.
}
}
\examples{
# Create an abj scenario from scratch and simulate it
DEB_abj() \%>\%
  set_init(c(L=0.02,E=0.1,H=0.01)) \%>\%
  set_param(c(p_M=3000,v=0.02,k_J=0.6,p_Am=300,kap=0.9,E_G=4000,f=1,
              E_Hj=0.05,E_Hp=0.3,kap_R=0.9,ke=1,c0=0,cT=1,L_b=0.02,
              L_j=0.04,MoA=0)) \%>\%
  set_exposure(no_exposure()) \%>\%
  set_times(0:10) \%>\%
  simulate()

# Print information about sample scenario 'americamysis'
americamysis

# Simulate 'americamysis' scenario
americamysis \%>\% simulate()
}
\seealso{
Other DEB models: 
\code{\link{DEB-models}},
\code{\link{DEBtox}()}
}
\concept{DEB models}
