% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sakoda_measure.R
\encoding{UTF-8}
\name{sakoda_measure}
\alias{sakoda_measure}
\title{Computes the Sakoda measure of a categorical time series}
\usage{
sakoda_measure(series, lag = 1, categories, features = FALSE)
}
\arguments{
\item{series}{A CTS.}

\item{lag}{The considered lag (default is 1).}

\item{categories}{A vector of type factor containing the corresponding
categories.}

\item{features}{Logical. If \code{features = FALSE} (default), the value of the Sakoda measure is returned. Otherwise, the function
returns a matrix with the individual components of the Sakoda measure.}
}
\value{
If \code{features = FALSE} (default), returns the value of the Sakoda measure. Otherwise, the function
returns a matrix of features, i.e., the matrix contains the features employed to compute the
Sakoda measure.
}
\description{
\code{sakoda_measure} returns the value of the Sakoda measure for
a categorical time series
}
\details{
Given a CTS of length \eqn{T} with range \eqn{\mathcal{V}=\{1, 2, \ldots, r\}},
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, the function computes the
estimated Sakoda measure, \eqn{\widehat{p}^*(l)=\sqrt{\frac{r\widehat{\Phi}^2(l)}{(r-1)(1+\widehat{\Phi}^2(l))}}},
where \eqn{\widehat{\Phi}^2(l)} is the estimated Phi2 measure. If \code{features = TRUE}, the function
returns the same output as the function \code{\link{pearson_measure}}.
}
\examples{
sm <- sakoda_measure(series = GeneticSequences$data[[1]],
categories = factor(c('a', 'c', 'g', 't'))) # Computing the Sakoda measure
# for the first series in dataset GeneticSequences
feature_matrix <- sakoda_measure(series = GeneticSequences$data[[1]],
categories = factor(c('a', 'c', 'g', 't')), features = TRUE) # Computing the corresponding
# matrix of features
}
\references{
{

  \insertRef{weiss2008measuring}{ctsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
