% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.csvy.R
\name{plot.csvy}
\alias{plot.csvy}
\title{Plot method for csvy objects
Generates a diagnostic or summary plot from a fitted \code{"csvy"} object.
Supports both single-factor and two-factor visualization. 
Aesthetic settings can be customized using \code{plot_csvy_control()}.}
\usage{
\method{plot}{csvy}(
  x,
  x1 = NULL,
  x2 = NULL,
  domains = NULL,
  type = c("constrained", "unconstrained", "both"),
  control = plot_csvy_control(),
  ...
)
}
\arguments{
\item{x}{An object of class \code{"csvy"}.}

\item{x1}{Optional. Name of the first factor to display in two-factor plots. Defaults to the first added variable.}

\item{x2}{Optional. Name of the second factor to display in two-factor plots. Defaults to the second added variable.}

\item{domains}{Optional. A data frame containing some domain(s) to be emphasized on the plot. Defaults to be NULL.}

\item{type}{Character string, either \code{"constrained"}, \code{"unconstrained"}, or \code{"both"}. Defaults to \code{"constrained"}.}

\item{control}{A list of display options returned by \code{\link{plot_csvy_control}}. Defaults to \code{plot_csvy_control()}.}

\item{...}{Additional arguments passed to \code{ggplot2::geom_line()} or \code{geom_point()}, such as \code{linewidth}, \code{size}, etc.}
}
\value{
A \code{ggplot2} object.
}
\description{
Plot method for csvy objects
Generates a diagnostic or summary plot from a fitted \code{"csvy"} object.
Supports both single-factor and two-factor visualization. 
Aesthetic settings can be customized using \code{plot_csvy_control()}.
}
\examples{
# plot.csvy(fit)
# plot.csvy(fit, x1 = "education", x2 = "region", control = plot_csvy_control(x1lab = "Education"))
}
\seealso{
\code{\link{plot_csvy_control}} for a full list of customizable settings.
}
