/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.qa.diff;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jump.util.CoordinateArrays;
import com.vividsolutions.jump.util.Counter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class UnmatchedEdgeExtracter {
    private boolean isDiff;
    private Map lineMap = new TreeMap();

    public static LineString toLinestring(LineSegment lineseg, GeometryFactory fact) {
        Coordinate[] coords = new Coordinate[]{lineseg.p0, lineseg.p1};
        return fact.createLineString(coords);
    }

    public void add(Geometry geom) {
        this.add(CoordinateArrays.toCoordinateArrays(geom, false));
    }

    public void add(LineString line) {
        this.add(line.getCoordinates());
    }

    public void add(List coordArrays) {
        Iterator i = coordArrays.iterator();
        while (i.hasNext()) {
            this.add((Coordinate[])i.next());
        }
    }

    public void add(Coordinate[] coord) {
        for (int i = 0; i < coord.length - 1; ++i) {
            LineSegment lineseg = new LineSegment(coord[i], coord[i + 1]);
            lineseg.normalize();
            Counter counter = (Counter)this.lineMap.get(lineseg);
            if (counter == null) {
                this.lineMap.put(lineseg, new Counter(1));
                continue;
            }
            counter.increment();
        }
    }

    public boolean isMatched(LineSegment lineseg) {
        Counter counter = (Counter)this.lineMap.get(lineseg);
        if (counter == null) {
            return false;
        }
        if (this.isDiff) {
            return true;
        }
        return counter.getValue() > 1;
    }

    public void getDiffEdges(Geometry geom, List edgeList) {
        this.getEdges(CoordinateArrays.toCoordinateArrays(geom, false), true, edgeList);
    }

    public void getUnmatchedEdges(Geometry geom, List edgeList) {
        this.getEdges(CoordinateArrays.toCoordinateArrays(geom, false), false, edgeList);
    }

    private void getEdges(List coordArrays, boolean isDiff, List edgeList) {
        Iterator i = coordArrays.iterator();
        while (i.hasNext()) {
            this.getEdges((Coordinate[])i.next(), isDiff, edgeList);
        }
    }

    private void getEdges(Coordinate[] coord, boolean isDiff, List edgeList) {
        this.isDiff = isDiff;
        GeometryFactory fact = new GeometryFactory();
        int start = 0;
        while (start < coord.length - 1) {
            int end = this.getUnmatchedSequenceEnd(coord, start);
            if (start < end) {
                Coordinate[] edgeCoord = new Coordinate[end - start + 1];
                int edgeIndex = 0;
                for (int i = start; i <= end; ++i) {
                    edgeCoord[edgeIndex++] = coord[i];
                }
                LineString edge = fact.createLineString(edgeCoord);
                edgeList.add(edge);
                start = end;
                continue;
            }
            ++start;
        }
    }

    public int getUnmatchedSequenceEnd(Coordinate[] coord, int start) {
        int index;
        LineSegment lineseg = new LineSegment();
        for (index = start; index < coord.length - 1; ++index) {
            lineseg.setCoordinates(coord[index], coord[index + 1]);
            lineseg.normalize();
            if (this.isMatched(lineseg)) break;
        }
        return index;
    }
}

