/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.plugin.edit;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDatasetFactory;
import com.vividsolutions.jump.geom.LineSegmentUtil;
import com.vividsolutions.jump.plugin.edit.UniqueSegmentsExtracter;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;

public class ExtractSegmentsPlugIn
extends ThreadedBasePlugIn {
    private MultiInputDialog dialog;
    private String layerName;
    private int inputEdgeCount = 0;
    private int uniqueSegmentCount = 0;
    private static final String LAYER = "Layer";

    private static List toLineStrings(Collection segments) {
        GeometryFactory fact = new GeometryFactory();
        ArrayList<LineString> lineStringList = new ArrayList<LineString>();
        Iterator i = segments.iterator();
        while (i.hasNext()) {
            LineSegment seg = (LineSegment)i.next();
            LineString ls = LineSegmentUtil.asGeometry(fact, seg);
            lineStringList.add(ls);
        }
        return lineStringList;
    }

    public String getName() {
        return "Extract Segments";
    }

    public EnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(this.dialog, context);
        GUIUtil.centreOnWindow((Component)this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        monitor.report("Extracting Segments...");
        Layer layer = this.dialog.getLayer(LAYER);
        FeatureCollectionWrapper lineFC = layer.getFeatureCollectionWrapper();
        this.inputEdgeCount = lineFC.size();
        UniqueSegmentsExtracter extracter = new UniqueSegmentsExtracter(monitor);
        extracter.add(lineFC);
        Collection uniqueFSList = extracter.getSegments();
        this.uniqueSegmentCount = uniqueFSList.size();
        List linestringList = ExtractSegmentsPlugIn.toLineStrings(uniqueFSList);
        if (monitor.isCancelRequested()) {
            return;
        }
        this.createLayers(context, linestringList);
    }

    private void createLayers(PlugInContext context, List linestringList) throws Exception {
        FeatureCollection lineStringFC = FeatureDatasetFactory.createFromGeometry(linestringList);
        context.addLayer("Result", this.layerName + " Extracted Segs", lineStringFC);
        this.createOutput(context);
    }

    private void createOutput(PlugInContext context) {
        context.getOutputFrame().createNewDocument();
        context.getOutputFrame().addHeader(1, "Extract Segments");
        context.getOutputFrame().addField("Layer: ", this.layerName);
        context.getOutputFrame().addText(" ");
        context.getOutputFrame().addField("# Unique Segments Extracted: ", "" + this.uniqueSegmentCount);
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarImage((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("ExtractSegments.png")));
        dialog.setSideBarDescription("Extracts all unique line segments from a dataset. ");
        JComboBox addLayerComboBox = dialog.addLayerComboBox(LAYER, context.getCandidateLayer(0), null, context.getLayerManager());
    }

    private void getDialogValues(MultiInputDialog dialog) {
        Layer layer = dialog.getLayer(LAYER);
        this.layerName = layer.getName();
    }
}

