/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.geom.precision;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.util.GeometryEditor;
import com.vividsolutions.jump.geom.precision.CoordinatePrecisionReducer;
import com.vividsolutions.jump.geom.precision.NumberPrecisionReducer;

public class GeometryPrecisionReducer {
    private CoordinatePrecisionReducer coordPrecReducer;
    private GeometryEditor geomEdit = new GeometryEditor();

    public GeometryPrecisionReducer(NumberPrecisionReducer numberPrecReducer) {
        this.coordPrecReducer = new CoordinatePrecisionReducer(numberPrecReducer);
    }

    public Geometry reduce(Geometry geom) {
        return this.geomEdit.edit(geom, (GeometryEditor.GeometryEditorOperation)new PrecisionReducerCoordinateOperation());
    }

    private class PrecisionReducerCoordinateOperation
    extends GeometryEditor.CoordinateOperation {
        private PrecisionReducerCoordinateOperation() {
        }

        public Coordinate[] edit(Coordinate[] coordinates, Geometry geom) {
            for (int i = 0; i < coordinates.length; ++i) {
                GeometryPrecisionReducer.this.coordPrecReducer.reducePrecision(coordinates[i]);
            }
            CoordinateList noRepeatedCoordList = new CoordinateList(coordinates, false);
            Coordinate[] noRepeatedCoord = noRepeatedCoordList.toCoordinateArray();
            if (geom instanceof LinearRing && noRepeatedCoord.length <= 3) {
                return coordinates;
            }
            if (geom instanceof LineString && noRepeatedCoord.length <= 1) {
                return coordinates;
            }
            return noRepeatedCoord;
        }
    }
}

