/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustCGAlgorithms;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.util.ArrayList;
import java.util.List;

public class OffsetCurveBuilder {
    private static double PI_OVER_2 = 1.5707963267948966;
    public static final int DEFAULT_QUADRANT_SEGMENTS = 8;
    private static final Coordinate[] arrayTypeCoordinate = new Coordinate[0];
    private CGAlgorithms cga = new RobustCGAlgorithms();
    private LineIntersector li;
    private double filletAngleQuantum;
    private double maxCurveSegmentError = 0.0;
    private ArrayList ptList;
    private double distance = 0.0;
    private PrecisionModel precisionModel;
    private int endCapStyle = 1;
    private int joinStyle;
    private Coordinate s0;
    private Coordinate s1;
    private Coordinate s2;
    private LineSegment seg0 = new LineSegment();
    private LineSegment seg1 = new LineSegment();
    private LineSegment offset0 = new LineSegment();
    private LineSegment offset1 = new LineSegment();
    private int side = 0;
    private static double MAX_CLOSING_SEG_LEN = 3.0;

    public OffsetCurveBuilder(PrecisionModel precisionModel) {
        this(precisionModel, 8);
    }

    public OffsetCurveBuilder(PrecisionModel precisionModel, int quadrantSegments) {
        this.precisionModel = precisionModel;
        this.li = new RobustLineIntersector();
        int limitedQuadSegs = quadrantSegments < 1 ? 1 : quadrantSegments;
        this.filletAngleQuantum = 1.5707963267948966 / (double)limitedQuadSegs;
    }

    public void setEndCapStyle(int endCapStyle) {
        this.endCapStyle = endCapStyle;
    }

    public List getLineCurve(Coordinate[] inputPts, double distance) {
        ArrayList<Coordinate[]> lineList = new ArrayList<Coordinate[]>();
        if (distance <= 0.0) {
            return lineList;
        }
        this.init(distance);
        if (inputPts.length <= 1) {
            switch (this.endCapStyle) {
                case 1: {
                    this.addCircle(inputPts[0], distance);
                    break;
                }
                case 3: {
                    this.addSquare(inputPts[0], distance);
                }
            }
        } else {
            this.computeLineBufferCurve(inputPts);
        }
        Coordinate[] lineCoord = this.getCoordinates();
        lineList.add(lineCoord);
        return lineList;
    }

    public List getRingCurve(Coordinate[] inputPts, int side, double distance) {
        ArrayList<Coordinate[]> lineList = new ArrayList<Coordinate[]>();
        this.init(distance);
        if (inputPts.length <= 2) {
            return this.getLineCurve(inputPts, distance);
        }
        if (distance == 0.0) {
            lineList.add(OffsetCurveBuilder.copyCoordinates(inputPts));
            return lineList;
        }
        this.computeRingBufferCurve(inputPts, side);
        lineList.add(this.getCoordinates());
        return lineList;
    }

    private static Coordinate[] copyCoordinates(Coordinate[] pts) {
        Coordinate[] copy = new Coordinate[pts.length];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = new Coordinate(pts[i]);
        }
        return copy;
    }

    private void init(double distance) {
        this.distance = distance;
        this.maxCurveSegmentError = distance * (1.0 - Math.cos(this.filletAngleQuantum / 2.0));
        this.ptList = new ArrayList();
    }

    private Coordinate[] getCoordinates() {
        Coordinate end;
        Coordinate start;
        if (this.ptList.size() > 1 && !(start = (Coordinate)this.ptList.get(0)).equals(end = (Coordinate)this.ptList.get(this.ptList.size() - 1))) {
            this.addPt(start);
        }
        Coordinate[] coord = this.ptList.toArray(arrayTypeCoordinate);
        return coord;
    }

    private void computeLineBufferCurve(Coordinate[] inputPts) {
        int i;
        int n = inputPts.length - 1;
        this.initSideSegments(inputPts[0], inputPts[1], 1);
        for (i = 2; i <= n; ++i) {
            this.addNextSegment(inputPts[i], true);
        }
        this.addLastSegment();
        this.addLineEndCap(inputPts[n - 1], inputPts[n]);
        this.initSideSegments(inputPts[n], inputPts[n - 1], 1);
        for (i = n - 2; i >= 0; --i) {
            this.addNextSegment(inputPts[i], true);
        }
        this.addLastSegment();
        this.addLineEndCap(inputPts[1], inputPts[0]);
        this.closePts();
    }

    private void computeRingBufferCurve(Coordinate[] inputPts, int side) {
        int n = inputPts.length - 1;
        this.initSideSegments(inputPts[n - 1], inputPts[0], side);
        for (int i = 1; i <= n; ++i) {
            boolean addStartPoint = i != 1;
            this.addNextSegment(inputPts[i], addStartPoint);
        }
        this.closePts();
    }

    private void addPt(Coordinate pt) {
        Coordinate bufPt = new Coordinate(pt);
        this.precisionModel.makePrecise(bufPt);
        Coordinate lastPt = null;
        if (this.ptList.size() >= 1) {
            lastPt = (Coordinate)this.ptList.get(this.ptList.size() - 1);
        }
        if (lastPt != null && bufPt.equals(lastPt)) {
            return;
        }
        this.ptList.add(bufPt);
    }

    private void closePts() {
        if (this.ptList.size() < 1) {
            return;
        }
        Coordinate startPt = new Coordinate((Coordinate)this.ptList.get(0));
        Coordinate lastPt = (Coordinate)this.ptList.get(this.ptList.size() - 1);
        Coordinate last2Pt = null;
        if (this.ptList.size() >= 2) {
            last2Pt = (Coordinate)this.ptList.get(this.ptList.size() - 2);
        }
        if (startPt.equals(lastPt)) {
            return;
        }
        this.ptList.add(startPt);
    }

    private void initSideSegments(Coordinate s1, Coordinate s2, int side) {
        this.s1 = s1;
        this.s2 = s2;
        this.side = side;
        this.seg1.setCoordinates(s1, s2);
        this.computeOffsetSegment(this.seg1, side, this.distance, this.offset1);
    }

    private void addNextSegment(Coordinate p, boolean addStartPoint) {
        boolean outsideTurn;
        this.s0 = this.s1;
        this.s1 = this.s2;
        this.s2 = p;
        this.seg0.setCoordinates(this.s0, this.s1);
        this.computeOffsetSegment(this.seg0, this.side, this.distance, this.offset0);
        this.seg1.setCoordinates(this.s1, this.s2);
        this.computeOffsetSegment(this.seg1, this.side, this.distance, this.offset1);
        if (this.s1.equals(this.s2)) {
            return;
        }
        int orientation = CGAlgorithms.computeOrientation(this.s0, this.s1, this.s2);
        boolean bl = outsideTurn = orientation == -1 && this.side == 1 || orientation == 1 && this.side == 2;
        if (orientation == 0) {
            this.li.computeIntersection(this.s0, this.s1, this.s1, this.s2);
            int numInt = this.li.getIntersectionNum();
            if (numInt >= 2) {
                this.addFillet(this.s1, this.offset0.p1, this.offset1.p0, -1, this.distance);
            }
        } else if (outsideTurn) {
            if (addStartPoint) {
                this.addPt(this.offset0.p1);
            }
            this.addFillet(this.s1, this.offset0.p1, this.offset1.p0, orientation, this.distance);
            this.addPt(this.offset1.p0);
        } else {
            this.li.computeIntersection(this.offset0.p0, this.offset0.p1, this.offset1.p0, this.offset1.p1);
            if (this.li.hasIntersection()) {
                this.addPt(this.li.getIntersection(0));
            } else if (this.offset0.p1.distance(this.offset1.p0) < this.distance / 1000.0) {
                this.addPt(this.offset0.p1);
            } else {
                this.addPt(this.offset0.p1);
                this.addPt(this.s1);
                this.addPt(this.offset1.p0);
            }
        }
    }

    private void addLastSegment() {
        this.addPt(this.offset1.p1);
    }

    private void computeOffsetSegment(LineSegment seg, int side, double distance, LineSegment offset) {
        int sideSign = side == 1 ? 1 : -1;
        double dx = seg.p1.x - seg.p0.x;
        double dy = seg.p1.y - seg.p0.y;
        double len = Math.sqrt(dx * dx + dy * dy);
        double ux = (double)sideSign * distance * dx / len;
        double uy = (double)sideSign * distance * dy / len;
        offset.p0.x = seg.p0.x - uy;
        offset.p0.y = seg.p0.y + ux;
        offset.p1.x = seg.p1.x - uy;
        offset.p1.y = seg.p1.y + ux;
    }

    private void addLineEndCap(Coordinate p0, Coordinate p1) {
        LineSegment seg = new LineSegment(p0, p1);
        LineSegment offsetL = new LineSegment();
        this.computeOffsetSegment(seg, 1, this.distance, offsetL);
        LineSegment offsetR = new LineSegment();
        this.computeOffsetSegment(seg, 2, this.distance, offsetR);
        double dx = p1.x - p0.x;
        double dy = p1.y - p0.y;
        double angle = Math.atan2(dy, dx);
        switch (this.endCapStyle) {
            case 1: {
                this.addPt(offsetL.p1);
                this.addFillet(p1, angle + 1.5707963267948966, angle - 1.5707963267948966, -1, this.distance);
                this.addPt(offsetR.p1);
                break;
            }
            case 2: {
                this.addPt(offsetL.p1);
                this.addPt(offsetR.p1);
                break;
            }
            case 3: {
                Coordinate squareCapSideOffset = new Coordinate();
                squareCapSideOffset.x = Math.abs(this.distance) * Math.cos(angle);
                squareCapSideOffset.y = Math.abs(this.distance) * Math.sin(angle);
                Coordinate squareCapLOffset = new Coordinate(offsetL.p1.x + squareCapSideOffset.x, offsetL.p1.y + squareCapSideOffset.y);
                Coordinate squareCapROffset = new Coordinate(offsetR.p1.x + squareCapSideOffset.x, offsetR.p1.y + squareCapSideOffset.y);
                this.addPt(squareCapLOffset);
                this.addPt(squareCapROffset);
            }
        }
    }

    private void addFillet(Coordinate p, Coordinate p0, Coordinate p1, int direction, double distance) {
        double dx0 = p0.x - p.x;
        double dy0 = p0.y - p.y;
        double startAngle = Math.atan2(dy0, dx0);
        double dx1 = p1.x - p.x;
        double dy1 = p1.y - p.y;
        double endAngle = Math.atan2(dy1, dx1);
        if (direction == -1) {
            if (startAngle <= endAngle) {
                startAngle += Math.PI * 2;
            }
        } else if (startAngle >= endAngle) {
            startAngle -= Math.PI * 2;
        }
        this.addPt(p0);
        this.addFillet(p, startAngle, endAngle, direction, distance);
        this.addPt(p1);
    }

    private void addFillet(Coordinate p, double startAngle, double endAngle, int direction, double distance) {
        int directionFactor = direction == -1 ? -1 : 1;
        double totalAngle = Math.abs(startAngle - endAngle);
        int nSegs = (int)(totalAngle / this.filletAngleQuantum + 0.5);
        if (nSegs < 1) {
            return;
        }
        double initAngle = 0.0;
        double currAngleInc = totalAngle / (double)nSegs;
        Coordinate pt = new Coordinate();
        for (double currAngle = initAngle; currAngle < totalAngle; currAngle += currAngleInc) {
            double angle = startAngle + (double)directionFactor * currAngle;
            pt.x = p.x + distance * Math.cos(angle);
            pt.y = p.y + distance * Math.sin(angle);
            this.addPt(pt);
        }
    }

    private void addCircle(Coordinate p, double distance) {
        Coordinate pt = new Coordinate(p.x + distance, p.y);
        this.addPt(pt);
        this.addFillet(p, 0.0, Math.PI * 2, -1, distance);
    }

    private void addSquare(Coordinate p, double distance) {
        this.addPt(new Coordinate(p.x + distance, p.y + distance));
        this.addPt(new Coordinate(p.x + distance, p.y - distance));
        this.addPt(new Coordinate(p.x - distance, p.y - distance));
        this.addPt(new Coordinate(p.x - distance, p.y + distance));
        this.addPt(new Coordinate(p.x + distance, p.y + distance));
    }
}

