/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util;

import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class SimpleTreeModel
implements TreeModel {
    private Object root;
    private ArrayList listeners = new ArrayList();
    private boolean firingEvents = true;

    public SimpleTreeModel(Object root) {
        this.root = root;
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isLeaf(Object node) {
        return !(node instanceof Folder) && this.getChildCount(node) == 0;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        for (int i = 0; i < this.getChildCount(parent); ++i) {
            if (child instanceof Folder && this.getChild(parent, i) instanceof Folder && this.getChild(parent, i).toString().equals(child.toString())) {
                return i;
            }
            if (this.getChild(parent, i) != child) continue;
            return i;
        }
        Assert.shouldNeverReachHere((String)(parent + ", " + child));
        return -1;
    }

    public void addTreeModelListener(TreeModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeTreeModelListener(TreeModelListener listener) {
        this.listeners.remove(listener);
    }

    public abstract List getChildren(Object var1);

    public Object getChild(Object parent, int index) {
        return this.children(parent).get(index);
    }

    private List children(Object parent) {
        return parent instanceof Folder ? ((Folder)parent).getChildren() : this.getChildren(parent);
    }

    public int getChildCount(Object parent) {
        return this.children(parent).size();
    }

    public void fireTreeNodesChanged(TreeModelEvent e) {
        if (!this.firingEvents) {
            return;
        }
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            TreeModelListener l = (TreeModelListener)i.next();
            l.treeNodesChanged(e);
        }
    }

    public void fireTreeNodesInserted(TreeModelEvent e) {
        if (!this.firingEvents) {
            return;
        }
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            TreeModelListener l = (TreeModelListener)i.next();
            l.treeNodesInserted(e);
        }
    }

    public void fireTreeNodesRemoved(TreeModelEvent e) {
        if (!this.firingEvents) {
            return;
        }
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            TreeModelListener l = (TreeModelListener)i.next();
            l.treeNodesRemoved(e);
        }
    }

    public void fireTreeStructureChanged(TreeModelEvent e) {
        if (!this.firingEvents) {
            return;
        }
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            TreeModelListener l = (TreeModelListener)i.next();
            l.treeStructureChanged(e);
        }
    }

    public void setFiringEvents(boolean firingEvents) {
        this.firingEvents = firingEvents;
    }

    public static abstract class Folder {
        private Class childrenClass;
        private String name;
        private Object parent;

        public Folder(String name, Object parent, Class childrenClass) {
            this.name = name;
            this.parent = parent;
            this.childrenClass = childrenClass;
        }

        public abstract List getChildren();

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Folder)) {
                return false;
            }
            Folder otherFolder = (Folder)other;
            return this.parent == otherFolder.parent && this.name.equals(otherFolder.name);
        }

        public Class getChildrenClass() {
            return this.childrenClass;
        }

        public Object getParent() {
            return this.parent;
        }
    }
}

