/*
 * Decompiled with CFR 0.152.
 */
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.ShapefileReader;
import com.vividsolutions.jump.io.ShapefileWriter;
import java.io.File;
import java.util.Iterator;

public class CShapesSimplifier {
    private FeatureCollection fc;
    private String packageHome = "/Users/nilsw/Projects/CShapes/Final/";

    public void run() {
        this.fc = null;
        try {
            File file = new File(this.packageHome, "cshapes.shp");
            DriverProperties dp = new DriverProperties(file.getAbsolutePath());
            this.fc = new ShapefileReader().read(dp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FeatureDataset fcnew = new FeatureDataset(this.fc.getFeatureSchema());
        Iterator it = this.fc.iterator();
        while (it.hasNext()) {
            Feature f = (Feature)it.next();
            Geometry simpleGeometry = TopologyPreservingSimplifier.simplify(f.getGeometry(), 0.3);
            f.setGeometry(simpleGeometry);
            fcnew.add(f);
        }
        try {
            File file = new File(this.packageHome, "cshapes_simple.shp");
            DriverProperties dp = new DriverProperties(file.getAbsolutePath());
            new ShapefileWriter().write(fcnew, dp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        CShapesSimplifier s = new CShapesSimplifier();
        s.run();
    }
}

