\name{mt}
\alias{dmt}
\alias{rmt}
\title{
  Multivariate Student t Distribution
}
\description{
  Density and random number generation for the multivariate Student 
  t distribution.
}
\usage{
dmt(x, df=stop("'df' argument is missing, with no default"), 
    mm=rep(0, length(x)), cov=diag(rep(1, length(x))))
rmt(n, df=stop("'df' argument is missing, with no default"), 
    mm=rep(0, mult), cov=diag(rep(1, mult)), mult, is.chol=FALSE)
}
\arguments{
  \item{x}{
    a single multivariate observation.  Missing values (\code{NA}s) 
    are allowed.
  }
  \item{n}{
    the sample size.  If \code{length(n)} is larger than 1, then 
    \code{length(n)} random vectors are returned, bound together in a 
    \code{length(n)} times \code{mult} matrix, where \code{mult} is 
    the dimension of the multivariate variable.
  }
  \item{df}{
    the degrees of freedom.  In \code{rmt} this is replicated to be 
    of the same length than the number of deviates generated by 
    \code{rmt}.
  }
  \item{mult}{
    the dimension of the multivariate Student t variate.
  }
  \item{mm}{
    a vector location parameter.  The default is a vector of 0's.
  }
  \item{cov}{
    a square scale matrix.  The default is the identity matrix.
  }
  \item{is.chol}{
    logical flag.  If \code{TRUE}, the argument \code{cov} is the 
    result from the Choleski decomposition of the original scale 
    matrix.
  }
}
\value{
  Returns the density (\code{dmt}) of or a random sample (\code{rmt}) 
  from the multivariate Student t distribution on \code{df} degrees 
  of freedom. 
}
\section{Side Effects}{
  The function \code{rmt} causes creation of the dataset 
  \code{\link{.Random.seed}} if it does not already exist, 
  otherwise its value is updated.
}
\section{Background}{
  The multivariate Student t distribution is a real valued symmetric
  distribution centered at \code{mm}.  It is defined as the ratio of a
  centred multivariate normal distribution with covariance matrix 
  \code{cov}, and the square root of an independent 
  \eqn{\chi^2}{Chi square} distribution with \code{df} degrees of 
  freedom subsequently translated by \code{mm}.  (See 
  \cite{Johnson and Kotz, 1976, par. 37.3, pg. 134ff}.)
  The multivariate t distribution approaches the multivariate Gaussian
  (\code{\link[stats]{Normal}}) distribution as the degrees of freedom 
  go to infinity.
}
\note{
  Elements of \code{x} that are missing will cause the corresponding
  elements of the result to be missing.
}
\references{
  Johnson, N. L. and Kotz, S. (1976) \emph{Distributions in 
  Statistics: Continuous Multivariate Distributions}.  New York: 
  Wiley.
}
\seealso{
  \code{\link[stats]{TDist}}, \code{\link[stats]{Normal}}, 
  \code{\link[base]{Random}}.
}
\examples{
dmt(c(0.1, -0.4), df = 4, mm = c(1, -1))  
## density of a bivariate t distribution with 4 degrees of freedom 
## and centered at (1,-1)

rmt(n = 100, df = 5, mult = 4)  
## generates 100 replicates of a standard four-variate t distribution 
## with 5 degress of freedom
}
\keyword{distribution}










