% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listCoins.R
\name{listCoins}
\alias{listCoins}
\title{Retrieves name, symbol, slug and rank for all tokens}
\usage{
listCoins(coin = NULL, start_date = NULL, end_date = NULL)
}
\arguments{
\item{coin}{Name, symbol or slug of crypto currency}

\item{start_date}{Start date to retrieve data from, format yyyymmdd}

\item{end_date}{Start date to retrieve data from, format yyyymmdd}

\item{...}{No arguments, return all coins}
}
\value{
Crypto currency historic OHLC market data in a dataframe:
  \item{symbol}{Coin symbol (not-unique)}
  \item{name}{Coin name}
  \item{slug}{Coin URL slug (unique)}
  \item{rank}{Current rank by market cap}
  \item{exchange_url}{Exchange market tables urls for scraping}
  \item{history_url}{Historical market tables urls for scraping}

Required dependency that is used in function call \code{getCoins()}.
}
\description{
List all of the crypto currencies that have existed on CoinMarketCap
and use this to populate the URL base for scraping historical market
data. It retrieves name, slug, symbol and rank of crypto currencies from
CoinMarketCap and creates URLS for \code{scraper()} to use.
}
\examples{
# return specific coin

coin <- "kin"
coins <- listCoins(coin)

\dontrun{

# return all coins
coin_list <- listCoins()
}

}
