% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab-book.R
\name{tabBook}
\alias{tabBook}
\title{Compute a Tab Book}
\usage{
tabBook(
  multitable,
  dataset,
  weight = crunch::weight(dataset),
  output_format = c("json", "xlsx", "csv"),
  file,
  filter = NULL,
  use_legacy_endpoint = envOrOption("use.legacy.tabbook.endpoint", FALSE, expect_lgl =
    TRUE),
  ...
)
}
\arguments{
\item{multitable}{a \code{Multitable} object}

\item{dataset}{CrunchDataset, which may be subset with a filter expression
on the rows, and a selection of variables to use on the columns.}

\item{weight}{a CrunchVariable that has been designated as a potential
weight variable for \code{dataset}, or \code{NULL} for unweighted results.
Default is the currently applied \code{\link{weight}}.}

\item{output_format}{character export format: currently supported values are "json"
(default), "xlsx" and "csv".}

\item{file}{character local filename to write to. A default filename will be
generated from the \code{multitable}'s name if one is not supplied and the
"xlsx" format is requested. Not required for "json" format export.}

\item{filter}{a Crunch \code{filter} object or a vector of names
of \code{\link{filters}} defined in the dataset.}

\item{use_legacy_endpoint}{Logical, indicating whether to use a 'legacy'
endpoint for compatibility (this endpoint will be removed in the future).
Defaults to \code{FALSE}, but can be set in the function, or with the environment
variable \code{R_USE_LEGACY_TABBOOK_ENDPOINT} or R option
\code{use.legacy.tabbook.endpoint}.}

\item{...}{Additional "options" passed to the tab book POST request.
More details can be found
\href{https://crunch.io/api/reference/#post-/datasets/-dataset_id-/multitables/}{in the crunch API documentation}}
}
\value{
If "json" format is requested, the function returns an object of
class \code{TabBookResult}, containing a list of \code{MultitableResult}
objects, which themselves contain \code{CrunchCube}s. If "xlsx" or "csv", is requested,
the function invisibly returns the filename (\code{file}, if specified, or the
the autogenerated file name). If you request "json" and wish to access the
JSON data underlying the \code{TabBookResult}, pass in a path for \code{file}
and you will get a JSON file written there as well.
}
\description{
This function allows you to generate a tab book from a multitable and data.
As with other functions, you can select the rows and columns you want to
work with by subsetting the \code{dataset} you pass into the function.
}
\details{
By specifying a "json" \code{format}, instead of generating an Excel
workbook, you'll get a TabBookResult object, containing nested CrunchCube
results. You can then further format these and construct custom tab reports.
}
\examples{
\dontrun{
# Excel export
m <- newMultitable(~ gender + age4 + marstat, data = ds)
tabBook(m, ds, format = "xlsx", file = "wealthy-tab-book.xlsx", filter = "wealthy")

# csv export
tabBook(
    mt,
    ds[c("q5a", "q8", "q2a_1", "q2a_2")],
    output_format = "csv",
    file = "tabbook.csv",
    format = list(
        pval_colors = FALSE,
        decimal_places = list(percentages = 0L, other = 2L),
        show_empty = FALSE
    ),
    sig_threshold = 0.05,
    doc_layout = list(toc = FALSE, variable_sheets = "one_sheet"),
    fields = c(
        "col_percent", "row_percent", "count_unweighted", "mean",
        "valid_count_weighted", "valid_count_unweighted"
    ),
    page_layout = list(
        rows = list(
            top = c("base_weighted", "base_unweighted"),
            bottom = c("scale_mean", "scale_median")
        ),
        measure_layout = "long"
    )
)

# JSON export (loads into R)
book <- tabBook(m, ds)
tables <- prop.table(book, 2)

}
}
