% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multitables.R
\name{newMultitable}
\alias{newMultitable}
\title{Create a new Multitable}
\usage{
newMultitable(formula, data, name, ...)
}
\arguments{
\item{formula}{an object of class 'formula' object with the
cross-classifying variables separated by '+' on the right-hand side.
Following how \code{\link[stats:formula]{stats::formula()}} works in R, it should start
with "~". Variables on left-hand side of the formula have no meaning in this
function.}

\item{data}{an object of class \code{CrunchDataset} in which to create the
multitable, and to which the variables referenced in \code{formula} belong.}

\item{name}{character name to give the new multitable object. If omitted,
a default name will be derived from \code{formula}.}

\item{...}{Additional multitable attributes to set. Options include
\code{is_public}.}
}
\value{
An object of class \code{Multitable}
}
\description{
Multitables, or "banners" or "crossbreaks", define a set of variables or
or query expressions to crosstab with as a unit. They are used in the Crunch
web app to display tables side by side, as well as to define one dimension
of a tab book.
}
\examples{
\dontrun{
m <- newMultitable(~ gender + age4 + marstat, data=ds)
name(m) # [1] "gender + age4 + marstat"
}
}
\seealso{
\code{\link[stats:formula]{stats::formula}}
}
