% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-datasets.R
\name{listDatasets}
\alias{listDatasets}
\title{Show the names of all Crunch datasets associated with a catalog}
\usage{
listDatasets(kind = c("active", "all", "archived"), project = NULL,
  refresh = FALSE, shiny = FALSE)
}
\arguments{
\item{kind}{character specifying whether to look in active, archived, or all
datasets. Default is "active", i.e. non-archived.}

\item{project}{\code{CrunchProject} entity, character name of a project, or
NULL, the default. If a Project entity or reference is supplied, the
function will display datasets from that Project's datasets. If NULL,
the primary dataset catalog for the user will be used.}

\item{refresh}{logical: should the function check the Crunch API for new
datasets? Default is FALSE.}

\item{shiny}{logical: launch a shiny gadget to help select the right dataset. The
gadget will return a valid \code{loadDataset()} call which loads the selected dataset.}
}
\value{
Character vector of dataset names, each of which would be a valid
input for \code{\link[=loadDataset]{loadDataset()}}
}
\description{
If \code{shiny} is TRUE the function launches a shiny gadget which allows you to
navigate your Crunch projects and datasets. This is useful if you can't
remember a dataset's project and also saves typing long dataset names.
}
