% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R, R/multitables.R, R/projects.R,
%   R/shoji-folder.R, R/shoji.R, R/teams.R, R/variable-delete.R
\docType{methods}
\name{delete}
\alias{delete}
\alias{delete,CrunchDataset-method}
\alias{delete,Multitable-method}
\alias{delete,CrunchProject-method}
\alias{delete,ShojiFolder-method}
\alias{delete,ShojiObject-method}
\alias{delete,ANY-method}
\alias{delete,CrunchTeam-method}
\alias{delete,CrunchVariable-method}
\alias{delete,VariableTuple-method}
\title{Delete a Crunch object from the server}
\usage{
\S4method{delete}{CrunchDataset}(x, ...)

\S4method{delete}{Multitable}(x, ...)

\S4method{delete}{CrunchProject}(x, ...)

\S4method{delete}{ShojiFolder}(x, ...)

\S4method{delete}{ShojiObject}(x, ...)

\S4method{delete}{ANY}(x, ...)

\S4method{delete}{CrunchTeam}(x, ...)

\S4method{delete}{CrunchVariable}(x, ...)

\S4method{delete}{VariableTuple}(x, ...)
}
\arguments{
\item{x}{a Crunch object}

\item{...}{additional arguments, in the generic}
}
\description{
These methods delete entities, notably Datasets and Variables within them,
from the server. This action is permanent and cannot be undone, so it
should not be done lightly. Consider instead using \code{archive}
for datasets and \code{hide} for variables.
}
\details{
Deleting requires confirmation. In an interactive session, you will be asked
to confirm. To avoid that prompt, or to delete objects from a
non-interactive session, wrap the call in \code{\link[=with_consent]{with_consent()}} to give
your permission to delete.
}
\seealso{
\link{hide} \link{deleteDataset}
}
