% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut.R
\docType{methods}
\name{crunch-cut}
\alias{crunch-cut}
\alias{cut,NumericVariable-method}
\title{Cut a numeric Crunch variable}
\usage{
\S4method{cut}{NumericVariable}(x, breaks, labels = NULL, name,
  include.lowest = FALSE, right = TRUE, dig.lab = 3,
  ordered_result = FALSE, ...)
}
\arguments{
\item{x}{A Crunch \code{NumericVariable}}

\item{breaks}{Either a numeric vector of two or more unique cut points
or a single number giving the number of intervals into which \code{x} is to be
cut. If specifying cut points, values that are less than the smallest value
in \code{breaks} or greater than the largest value in \code{breaks} will be marked
missing in the resulting categorical variable.}

\item{labels}{A character vector representing the labels for the levels of
the resulting categories. The length of the labels argument should be the
same as the number of categories, which is one fewer than the number of
breaks. If not specified, labels are constructed using interval notation.
For example, \code{[1, 5)} indicates that the category goes from 1 to 5. The
bracket shape indicates whether the boundary value is included in the
category, i.e. whether it is "closed". \code{[1, 5)} indicates that the interval
includes (is closed on) 1 but does not include (is open on) 5.
If labels = FALSE, simple integer codes are returned instead of a factor.}

\item{name}{The name of the resulting Crunch variable as a character string.}

\item{include.lowest}{logical, indicating if an \code{x[i]} equal to the lowest
(or highest, for right = FALSE) \code{breaks} value should be included.}

\item{right}{logical, indicating if the intervals should be closed on the
right (and open on the left) or vice versa.}

\item{dig.lab}{integer which is used when labels are not given.
It determines the number of digits used in formatting the break numbers.}

\item{ordered_result}{Ignored.}

\item{...}{further arguments passed to \link{makeCaseVariable}}
}
\value{
a Crunch \code{\link{VariableDefinition}}. Assign it into the dataset to create
it as a derived variable on the server.
}
\description{
\code{crunch::cut()} is equivalent to \code{base::cut()} except that it operates on
Crunch variables instead of in-memory R objects. The function takes a numeric
variable and derives a new categorical variable from it based on the \code{breaks}
argument. You can either break the variable into evenly spaced categories by
specifying the number of breaks, or specify a numeric vector identifying
the start and end point of each category. For example, specifying
\code{breaks = 5} will break the numeric data into five evenly spaced portions
while \code{breaks = c(1, 5, 10)} will recode the data into two groups based on
whether the numeric vector falls between 1 and 5 or 5 and 10.
}
\examples{
\dontrun{
ds <- loadDataset("mtcars")
ds$cat_var <- cut(ds$mpg, breaks = c(10, 15, 20),
    labels = c("small", "medium"), name = "Fuel efficiency")
ds$age <- sample(1:100, 32)
ds$age4 <- cut(df$age, c(0, 30, 45, 65, 200),
           c("Youth", "Adult", "Middle-aged", "Elderly"),
           name = "Age (4 category)")
}
}
