% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{IncrementsRelativeParts-class}
\alias{IncrementsRelativeParts-class}
\alias{.IncrementsRelativeParts}
\title{Increments control based on relative differences in intervals,
with special rules for part 1 and beginning of part 2}
\description{
Note that this only works in conjunction with \code{\linkS4class{DataParts}}
objects. If the part 2 will just be started in the next cohort, then the
next maximum dose will be either \code{dltStart} (e.g. -1) shift of the last
part 1 dose in case of a DLT in part 1, or \code{cleanStart} shift (e.g. 0)
in case of no DLTs in part 1. If part 1 will still be on in the next cohort,
then the next dose level will be the next higher dose level in the
\code{part1Ladder} of the data object. If part 2 has been started before,
the usual relative increment rules apply, see
\code{\linkS4class{IncrementsRelative}}.
}
\section{Slots}{

\describe{
\item{\code{dltStart}}{integer giving the dose level increment for starting part 2
in case of a DLT in part 1}

\item{\code{cleanStart}}{integer giving the dose level increment for starting part 2
in case of a DLT in part 1. If this is less or equal to 0, then the part 1
ladder will be used to find the maximum next dose. If this is larger than 0,
then the relative increment rules will be applied to find the next maximum
dose level.}
}}

\examples{

myIncrements <- IncrementsRelativeParts(dltStart=0,
                                        cleanStart=1)

}
\keyword{classes}
