% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Design-class.R
\docType{class}
\name{RuleDesign-class}
\alias{RuleDesign-class}
\alias{.RuleDesign}
\title{Class for rule-based designs}
\description{
The difference to \code{\linkS4class{Design}} class is that
model, stopping and increments slots are missing.
}
\section{Slots}{

\describe{
\item{\code{nextBest}}{how to find the next best dose, an object of class
\code{\linkS4class{NextBest}}}

\item{\code{cohortSize}}{rules for the cohort sizes,
an object of class \code{\linkS4class{CohortSize}}}

\item{\code{data}}{what is the dose grid, any previous data, etc., contained
in an object of class \code{\linkS4class{Data}}}

\item{\code{startingDose}}{what is the starting dose? Must lie on the grid in
\code{data}}
}}

\examples{

emptydata <- Data(doseGrid = c(5, 10, 15, 25, 35, 50, 80))

# inizialing a 3+3 design with constant cohort size of 3 and
# starting dose equal 5
myDesign <- RuleDesign(nextBest = NextBestThreePlusThree(),
                       cohortSize = CohortSizeConst(size=3L),
                       data = emptydata,
                       startingDose = 5)
  
  
}
\keyword{classes}
