% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{StoppingAll-class}
\alias{StoppingAll-class}
\alias{.StoppingAll}
\title{Stop based on fullfillment of all multiple stopping rules}
\description{
This class can be used to combine multiple stopping rules with an AND
operator.
}
\details{
\code{stopList} contains all stopping rules, which are again objects of
class \code{\linkS4class{Stopping}}. All stopping rules must be fulfilled in
order that the result of this rule is to stop.
}
\section{Slots}{

\describe{
\item{\code{stopList}}{list of stopping rules}
}}

\examples{

# Define some stopping rules
myStopping1 <- StoppingMinCohorts(nCohorts=3)
myStopping2 <- StoppingTargetProb(target=c(0.2, 0.35),
                                  prob=0.5)
myStopping3 <- StoppingMinPatients(nPatients=20)

# Create a list of stopping rules (of class 'StoppingAll') which would then be
# summarized by the 'all' function, meaning that the study would be stopped only if
# 'all' the single stopping rules are TRUE
mystopping <- StoppingAll(stopList=c(myStopping1,myStopping2,myStopping3))


}
\keyword{classes}
