% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Simulations-class.R
\docType{class}
\name{PseudoSimulationsSummary-class}
\alias{.PseudoSimulationsSummary}
\alias{PseudoSimulationsSummary-class}
\title{Class for the summary of pseudo-models simulations output}
\description{
Note that objects should not be created by users, therefore no
initialization function is provided for this class.
}
\section{Slots}{

\describe{
\item{\code{targetEndOfTrial}}{the target probability of DLE wanted at the end of a trial}

\item{\code{targetDoseEndOfTrial}}{the dose level corresponds to the target probability
of DLE wanted at the end of a trial}

\item{\code{targetDuringTrial}}{the target probability of DLE wanted during a trial}

\item{\code{targetDoseDuringTrial}}{the dose level corresponds to the target probability of DLE
wanted during the trial}

\item{\code{nsim}}{number of simulations}

\item{\code{propDLE}}{proportions of DLE in the trials}

\item{\code{meanToxRisk}}{mean toxicity risks for the patients}

\item{\code{doseSelected}}{doses selected as MTD (targetDoseEndOfTrial)}

\item{\code{toxAtDosesSelected}}{true toxicity at doses selected}

\item{\code{propAtTargetEndOfTrial}}{Proportion of trials selecting at the doseGrid closest below the MTD, the
targetDoseEndOfTrial}

\item{\code{propAtTargetDuringTrial}}{Proportion of trials selecting at the doseGrid closest below the
targetDoseDuringTrial}

\item{\code{doseMostSelected}}{dose most often selected as MTD}

\item{\code{obsToxRateAtDoseMostSelected}}{observed toxicity rate at dose most often
selected}

\item{\code{nObs}}{number of patients overall}

\item{\code{nAboveTargetEndOfTrial}}{number of patients treated above targetDoseEndOfTrial}

\item{\code{nAboveTargetDuringTrial}}{number of patients treated above targetDoseDuringTrial}

\item{\code{doseGrid}}{the dose grid that has been used}

\item{\code{fitAtDoseMostSelected}}{fitted toxicity rate at dose most often selected}

\item{\code{meanFit}}{list with the average, lower (2.5%) and upper (97.5%)
quantiles of the mean fitted toxicity at each dose level}
}}
\keyword{classes}

