% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{StoppingMTDdistribution-class}
\alias{.StoppingMTDdistribution}
\alias{StoppingMTDdistribution-class}
\title{Stop based on MTD distribution}
\description{
Has 90\% probability above a threshold of 50\% of the current
MTD been reached? This class is used for this question.
}
\section{Slots}{

\describe{
\item{\code{target}}{the target toxicity probability (e.g. 0.33) defining the MTD}

\item{\code{thresh}}{the threshold relative to the MTD (e.g. 0.5)}

\item{\code{prob}}{required probability (e.g. 0.9)}
}}
\examples{

# As example, here is the rule for: 
#   stopping the study if there is at least 0.9 probability that MTD > 0.5*next_dose.
#   Here MTD is defined as the dose for which prob(DLE)=0.33

myStopping <- StoppingMTDdistribution(target = 0.33,
                                      thresh = 0.5,
                                      prob = 0.9)

}
\keyword{classes}

