% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sch_relation.R
\name{sch_nr_relations}
\alias{sch_nr_relations}
\title{Nr. of Relations}
\usage{
sch_nr_relations(sch)
}
\arguments{
\item{sch}{A schedule object.}
}
\value{
A integer value indicating the number of relations.
}
\description{
Number of relations in a schedule as an integer value.
}
\examples{
sch <- sch_new() \%>\%
  sch_title("Fictitious Project Example") \%>\%
  sch_reference("VANHOUCKE, Mario. Measuring time:
  improving project performance using earned value management.
  Gent: Springer, 2009, p. 18") \%>\%
  sch_add_activity(  1L, "a1" , 0L, 2,3,4) \%>\%
  sch_add_activity(  2L, "a2" , 4L, 5) \%>\%
  sch_add_activity(  3L, "a3" , 9L, 10) \%>\%
  sch_add_activity(  4L, "a4" , 1L, 6) \%>\%
  sch_add_activity(  5L, "a5" , 4L, 9) \%>\%
  sch_add_activity(  6L, "a6" , 5L, 7) \%>\%
  sch_add_activity(  7L, "a7" , 1L, 8,11) \%>\%
  sch_add_activity(  8L, "a8" , 7L, 12) \%>\%
  sch_add_activity(  9L, "a9" , 8L, 12) \%>\%
  sch_add_activity( 10L, "a10", 3L, 12) \%>\%
  sch_add_activity( 11L, "a11", 3L, 12) \%>\%
  sch_add_activity( 12L, "a12", 0L) \%>\%
  sch_plan()
sch_nr_relations(sch) # 14

}
\seealso{
\code{\link[=sch_relations]{sch_relations()}}, \code{\link[=sch_topoi_la]{sch_topoi_la()}}, \code{\link[=sch_topoi_tf]{sch_topoi_tf()}},
\code{\link[=sch_all_successors]{sch_all_successors()}}, \code{\link[=sch_topoi_ad]{sch_topoi_ad()}}, \code{\link[=sch_nr_activities]{sch_nr_activities()}},
\code{\link[=sch_topoi_sp]{sch_topoi_sp()}}, \code{\link[=sch_has_any_relation]{sch_has_any_relation()}}, \code{\link[=sch_all_predecessors]{sch_all_predecessors()}},
\code{\link[=sch_add_relations]{sch_add_relations()}}, \code{\link[=sch_has_any_activity]{sch_has_any_activity()}}.
}
