% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sch_schedule.R
\name{sch_new}
\alias{sch_new}
\title{New Schedule}
\usage{
sch_new()
}
\value{
A list with schedule definition.
}
\description{
Create a new schedule without any information. The new schedule contains the
structure to include activities and relations.
}
\examples{
sch <- sch_new() \%>\%
  sch_add_activities(
    id = c(1L, 2L, 3L, 4L),
    name = c("A", "B", "C", "D"),
    duration = c(3L, 4L, 9L, 1L)
  ) \%>\%
  sch_add_relations(
    from = c(1L, 2L, 2L),
    to   = c(2L, 3L, 4L)
  ) \%>\%
  sch_plan()
sch_duration(sch) # 16

}
\seealso{
\code{\link[=sch_reference]{sch_reference()}}, \code{\link[=sch_add_activities]{sch_add_activities()}}, \code{\link[=sch_duration]{sch_duration()}},
\code{\link[=sch_xy_gantt_matrix]{sch_xy_gantt_matrix()}}, \code{\link[=sch_plan]{sch_plan()}}, \code{\link[=sch_add_relations]{sch_add_relations()}},
\code{\link[=sch_validate]{sch_validate()}}, \code{\link[=sch_non_critical_activities]{sch_non_critical_activities()}}, \code{\link[=sch_title]{sch_title()}}.
}
