% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_launcher_aws_batch.R
\name{crew_class_launcher_aws_batch}
\alias{crew_class_launcher_aws_batch}
\title{AWS Batch launcher class}
\description{
AWS Batch launcher \code{R6} class
}
\details{
See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.
}
\seealso{
Other plugin_aws_batch: 
\code{\link{crew_controller_aws_batch}()},
\code{\link{crew_launcher_aws_batch}()}
}
\concept{plugin_aws_batch}
\section{Super class}{
\code{\link[crew:crew_class_launcher]{crew::crew_class_launcher}} -> \code{crew_class_launcher_aws_batch}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{aws_batch_config}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_credentials}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_endpoint}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_region}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_job_definition}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_job_queue}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_share_identifier}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_scheduling_priority_override}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_parameters}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_container_overrides}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_node_overrides}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_retry_strategy}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_propagate_tags}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_timeout}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_tags}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_eks_properties_override}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_launcher_aws_batch-new}{\code{crew_class_launcher_aws_batch$new()}}
\item \href{#method-crew_class_launcher_aws_batch-validate}{\code{crew_class_launcher_aws_batch$validate()}}
\item \href{#method-crew_class_launcher_aws_batch-args_client}{\code{crew_class_launcher_aws_batch$args_client()}}
\item \href{#method-crew_class_launcher_aws_batch-args_submit}{\code{crew_class_launcher_aws_batch$args_submit()}}
\item \href{#method-crew_class_launcher_aws_batch-launch_worker}{\code{crew_class_launcher_aws_batch$launch_worker()}}
\item \href{#method-crew_class_launcher_aws_batch-terminate_worker}{\code{crew_class_launcher_aws_batch$terminate_worker()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="active"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-active'><code>crew::crew_class_launcher$active()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="booting"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-booting'><code>crew::crew_class_launcher$booting()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="call"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-call'><code>crew::crew_class_launcher$call()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="done"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-done'><code>crew::crew_class_launcher$done()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="errors"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-errors'><code>crew::crew_class_launcher$errors()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="forward"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-forward'><code>crew::crew_class_launcher$forward()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="launch"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-launch'><code>crew::crew_class_launcher$launch()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="rotate"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-rotate'><code>crew::crew_class_launcher$rotate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="scale"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-scale'><code>crew::crew_class_launcher$scale()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="set_name"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-set_name'><code>crew::crew_class_launcher$set_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="settings"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-settings'><code>crew::crew_class_launcher$settings()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="start"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-start'><code>crew::crew_class_launcher$start()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="summary"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-summary'><code>crew::crew_class_launcher$summary()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="tally"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-tally'><code>crew::crew_class_launcher$tally()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="terminate"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-terminate'><code>crew::crew_class_launcher$terminate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="terminate_workers"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-terminate_workers'><code>crew::crew_class_launcher$terminate_workers()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="unlaunched"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-unlaunched'><code>crew::crew_class_launcher$unlaunched()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="wait"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-wait'><code>crew::crew_class_launcher$wait()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher_aws_batch-new"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher_aws_batch-new}{}}}
\subsection{Method \code{new()}}{
Abstract launcher constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher_aws_batch$new(
  name = NULL,
  seconds_interval = NULL,
  seconds_timeout = NULL,
  seconds_launch = NULL,
  seconds_idle = NULL,
  seconds_wall = NULL,
  tasks_max = NULL,
  tasks_timers = NULL,
  reset_globals = NULL,
  reset_packages = NULL,
  reset_options = NULL,
  garbage_collection = NULL,
  launch_max = NULL,
  tls = NULL,
  processes = NULL,
  aws_batch_config = NULL,
  aws_batch_credentials = NULL,
  aws_batch_endpoint = NULL,
  aws_batch_region = NULL,
  aws_batch_job_definition = NULL,
  aws_batch_job_queue = NULL,
  aws_batch_share_identifier = NULL,
  aws_batch_scheduling_priority_override = NULL,
  aws_batch_parameters = NULL,
  aws_batch_container_overrides = NULL,
  aws_batch_node_overrides = NULL,
  aws_batch_retry_strategy = NULL,
  aws_batch_propagate_tags = NULL,
  aws_batch_timeout = NULL,
  aws_batch_tags = NULL,
  aws_batch_eks_properties_override = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{seconds_interval}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{seconds_timeout}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{seconds_launch}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{seconds_idle}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{seconds_wall}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{tasks_max}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{tasks_timers}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{reset_globals}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{reset_packages}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{reset_options}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{garbage_collection}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{launch_max}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{tls}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{processes}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_config}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_credentials}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_endpoint}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_region}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_job_definition}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_job_queue}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_share_identifier}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_scheduling_priority_override}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_parameters}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_container_overrides}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_node_overrides}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_retry_strategy}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_propagate_tags}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_timeout}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_tags}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{aws_batch_eks_properties_override}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An abstract launcher object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher_aws_batch-validate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher_aws_batch-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the launcher.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher_aws_batch$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly). Throws an error if a field is invalid.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher_aws_batch-args_client"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher_aws_batch-args_client}{}}}
\subsection{Method \code{args_client()}}{
Argument list for \code{paws.compute::batch()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher_aws_batch$args_client()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Argument list for \code{paws.compute::batch()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher_aws_batch-args_submit"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher_aws_batch-args_submit}{}}}
\subsection{Method \code{args_submit()}}{
Argument list for \code{paws.compute::batch()$submit_job()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher_aws_batch$args_submit(call, name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{call}}{Character of length 1, a namespaced call to \code{\link[=crew_worker]{crew_worker()}}
which will run in the worker and accept tasks.}

\item{\code{name}}{Character of length 1, an informative worker name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Argument list for \code{paws.compute::batch()$submit_job()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher_aws_batch-launch_worker"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher_aws_batch-launch_worker}{}}}
\subsection{Method \code{launch_worker()}}{
Launch a local process worker which will
dial into a socket.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher_aws_batch$launch_worker(
  call,
  name,
  launcher,
  worker,
  instance
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{call}}{Character of length 1, a namespaced call to \code{\link[=crew_worker]{crew_worker()}}
which will run in the worker and accept tasks.}

\item{\code{name}}{Character of length 1, an informative worker name.}

\item{\code{launcher}}{Character of length 1, name of the launcher.}

\item{\code{worker}}{Positive integer of length 1, index of the worker.
This worker index remains the same even when the current instance
of the worker exits and a new instance launches.
It is always between 1 and the maximum number of concurrent workers.}

\item{\code{instance}}{Character of length 1 to uniquely identify
the current instance of the worker.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The \code{call} argument is R code that will run to
initiate the worker.
}

\subsection{Returns}{
A handle object to allow the termination of the worker
later on.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher_aws_batch-terminate_worker"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher_aws_batch-terminate_worker}{}}}
\subsection{Method \code{terminate_worker()}}{
Terminate a local process worker.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher_aws_batch$terminate_worker(handle)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{handle}}{A process handle object previously
returned by \code{launch_worker()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
}
