% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crwPredict.R
\name{crwPredict}
\alias{crwPredict}
\title{Predict animal locations and velocities using a fitted CTCRW model and
calculate measurement error fit statistics}
\usage{
crwPredict(object.crwFit, predTime = NULL, flat = TRUE, ...)
}
\arguments{
\item{object.crwFit}{A model object from \code{\link{crwMLE}}.}

\item{predTime}{vector of additional prediction times (numeric or POSIXct).}

\item{flat}{logical. Should the result be returned as a flat data.frame.}

\item{...}{Additional arguments for testing new features}
}
\value{
List with the following elements:

\item{originalData}{A data.frame with is \code{data} merged with
\code{predTime}.}

\item{alpha.hat}{Predicted state}

\item{Var.hat}{array where \code{Var.hat[,,i]} is the prediction
covariance matrix for \code{alpha.hat[,i]}.}

\item{fit.test}{A data.frame of chi-square fit (df=2) statistics and naive
(pointwise) p-values.}

If \code{flat} is set to \code{TRUE} then a data set is returned with the
columns of the original data plus the state estimates, standard errors (se),
speed estimates, and the fit statistics and naive p-values.
}
\description{
The \code{crwMEfilter} function uses a fitted model object from
\code{crwMLE} to predict animal locations (with estimated uncertainty) at
times in the original data set and supplimented by times in \code{predTime}.
If \code{speedEst} is set to \code{TRUE}, then animal log-speed is also
estimated. In addition, the measurement error shock detection filter of de
Jong and Penzer (1998) is also calculated to provide a measure for outlier
detection.
}
\details{
The requirements for \code{data} are the same as those for fitting the model
in \code{\link{crwMLE}}.
}
\author{
Devin S. Johnson
}
\references{
de Jong, P. and Penzer, J. (1998) Diagnosing shocks in time
series. Journal of the American Statistical Association 93:796-806.
}

