% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependence_tree.R
\name{compute_dependence_tree}
\alias{compute_dependence_tree}
\title{Computes the dependence tree of a package}
\usage{
compute_dependence_tree(x, package = NULL, generation = 0)
}
\arguments{
\item{x}{a  \code{\link{cranly_network}} object.}

\item{package}{a vector of character strings with the package names to be matched. If \code{Inf} all available packages in \code{x} are returned. If \code{NULL} (default) nothing is matched.}

\item{generation}{integer. The original generation for the package.}
}
\description{
Computes the dependence tree of a package
}
\details{
Implements a recursion that computes the full dependence tree of a
\code{package} from \code{x}. Specifically, the packages that are
requirements for \code{package} (\code{Depends}, \code{Imports} or
\code{LinkingTo}) are found, then the requirements for those
packages are found, and so on.
}
\seealso{
\code{\link{build_dependence_tree.cranly_network}}
}
