% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventsTab.R
\name{eventTab}
\alias{eventTab}
\title{Number of events tables}
\usage{
eventTab(time, risk, group, cens = NULL, title = "Number of Events")
}
\arguments{
\item{time}{vector with times of the first event or follow-up, must be numeric.}

\item{risk}{vector with type of event, can be numeric or factor/character.}

\item{group}{vector with group variable, can be numeric or factor/character.}

\item{cens}{value of 'risk' indicating censored observation (if NULL, the first value of 'risk' vector will be taken).}

\item{title}{title of a table.}
}
\value{
A grob with n tables, where n is number of risks. Each table contains number of events that have happened in each group up to given time point (the time points correspond to breaks at x-axis of plots with cumulative incidence curves).
}
\description{
Creates a table for each risk, containing number of events up to given time in groups.
}
\examples{
eventTab(time = LUAD$time, risk = LUAD$event, group = LUAD$gender, cens = "alive",
title = "Number of events")
}
\seealso{
\code{\link[cr17]{plotCuminc}}
}
