% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{refine_ordinate}
\alias{refine_ordinate}
\alias{coarsen_ordinate}
\alias{hat_ordinate}
\alias{insertion_matrix}
\title{Knot Insertion, Removal, and Reinsertion}
\usage{
refine_ordinate(x, xi, theta, order = 4L)

coarsen_ordinate(x, xi, theta, order = 4L)

hat_ordinate(x, xi, theta, order = 4L)

insertion_matrix(x, xi, order = 4L)
}
\arguments{
\item{x}{the value of the knot to be inserted into the knot vector}

\item{xi}{the (whole) knot vector, including the repeated boundary knots.
Regardless of refinement or coarsening, this vector should be the
'reduced' vector such that x will be added to it.  See details and
examples.}

\item{theta}{the ordinates of the control polygon vertices}

\item{order}{the order of the B-spline, defaults to 4 for cubic splines}
}
\value{
numeric vectors
}
\description{
Functions for the insertion, removal, and reinsertion of internal knots for
B-splines.
}
\details{
\code{refine_ordinate} provides the estimated ordinates of the control
polygon's vertex sequence after inserting the value \code{x} into the knot
vector \code{xi}.

\code{coarsen_ordinate} provides the estimated ordinates of the control
polygon's vertex sequence after the removal of the the value \code{x} from the
knot vector \code{xi}.  The expected input for this function is the value
\code{x} to insert into \code{xi}.  That is, to find the estimate of the
coarsened ordinates by removing the value 2 from the vector (0, 0, 0, 0, 1,
2, 3, 4, 4, 4, 4) (the knot vector for a cubic B-spline with boundary knots
at zero and four and internal knots 1, 2, 3) should be specified by
\code{coarsen_ordinate(x = 2, xi = c(0, 0, 0, 0, 1, 3, 4, 4, 4, 4), theta)}.

The function \code{hat_ordinate} is the coarsen-then-refine estimate of the
ordinate vector.  The name comes from the the use of a hat matrix based on the
in knot insertion matrix.

Examples for the \code{refine_ordinate}, \code{coarsen_ordinate}, and
\code{hat_ordinate} are best shown in the vignette,
\code{vignette("cpr-pkg", package = "cpr")}.

\code{iknot_weights} returns a vector with the 'importance weight' of each
of the internal knots in \code{xi}.
}
\examples{
\dontrun{
# See the vignette
vignette("cpr-pkg", package = "cpr")
}

}
