% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cppcor.R
\name{cppcor}
\alias{cppcor}
\title{Probabilistic Composition of Correlated Preference}
\usage{
cppcor(dataset, ID = FALSE, cores = 1)
}
\arguments{
\item{dataset}{Data frame object}

\item{ID}{Logical argument, \code{TRUE} or \code{FALSE}. The default is \code{FALSE}}

\item{cores}{The number of cores to use for parallel execution. The default is 1.}
}
\value{
\code{cppcor} return the confusion matriz and parameters of classification analysis
}
\description{
\code{cppcor} function that returns the confusion matrix and parameters of classification analysis
}
\details{
The \code{dataset} argument must be a data frame object, and the last column must
be the classes of the evaluated elements.
The \code{ID} argument must be \code{FALSE} if the data are correlated and \code{TRUE} if the data
are independents.
}
\examples{
# Seed
set.seed(10)
c1 <- matrix(rnorm(30, mean = c(70,80,90), sd = 30), 10, 3, byrow = TRUE)
c2 <- matrix(rnorm(45, mean = c(30,40,50), sd = 10), 15, 3, byrow = TRUE)
# Data set
dataset <- as.data.frame(cbind(rbind(c1,c2), c(rep(1, 10), rep(2, 15))))
colnames(dataset) <- c("Var1", "Var2", "Var3", "Class")
# Loading package
library(cppcor)
cppcor(dataset, ID = FALSE)
}
