% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpop.R
\name{estimate}
\alias{estimate}
\alias{estimate,cpop.class-method}
\title{Estimate the fit of a cpop model}
\arguments{
\item{object}{An instance of an S4 class produced by \code{\link{cpop}}.}

\item{x}{Locations at which the fit is to be estimated. Default value is the x locations at which the cpop object was defined.}

\item{...}{Additional arguments.}
}
\value{
A data frame with two columns containing the locations x and the corresponding estimates y_hat.
}
\description{
Estimates the fit of a cpop model at the specified locations. If no locations are specified it evaluates the estimates
at the locations specified when calling \code{\link{cpop}}.
}
\examples{
library(cpop)

# simulate data with change in gradient
set.seed(1)
x <- (1:50/5)^2
y <- simchangeslope(x,changepoints=c(10,50),change.slope=c(0.25,-0.25),sd=1)

# determine changepoints
res <- cpop(y,x,beta=2*log(length(y)))

# estimate fit at points used in call to cpop
estimate(res)

# estimate fit at specified locations
estimate(res,seq(0,100,10))

#extrapolate fit
estimate(res,seq(-20,140,20))

}
\references{
\insertRef{cpop-jss-article-2024}{cpop}
}
