% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitctp.R
\name{fitcbp}
\alias{fitcbp}
\title{Maximum-likelihood fitting of the CBP distribution}
\usage{
fitcbp(x, bstart = NULL, gammastart = NULL, method = "L-BFGS-B", control = list(), ...)
}
\arguments{
\item{x}{A numeric vector of length at least one containing only finite values.}

\item{bstart}{A starting value for the parameter \eqn{b}; by default NULL.}

\item{gammastart}{A starting value for the parameter \eqn{\gamma>0}; by default NULL.}

\item{method}{The method to be used in fitting the model. See 'Details'.}

\item{control}{A list of parameters for controlling the fitting process.}

\item{...}{Additional parameters.}
}
\value{
An object of class \code{'fitCBP'} is a list containing the following components:

\itemize{
\item \code{n}, the number of observations,
\item \code{initialValues}, a vector with the starting values used,
\item \code{coefficients}, the parameter ML estimates of the CTP distribution,
\item \code{se}, a vector of the standard error estimates,
\item \code{hessian}, a symmetric matrix giving an estimate of the Hessian at the solution found in the optimization of the log-likelihood function,
\item \code{cov}, an estimate of the covariance matrix of the model coefficients,
\item \code{corr}, an estimate of the correlation matrix of the model estimates,
\item \code{loglik}, the maximized log-likelihood,
\item \code{aic}, Akaike Information Criterion, minus twice the maximized log-likelihood plus twice the number of parameters,
\item \code{bic}, Bayesian Information Criterion, minus twice the maximized log-likelihood plus twice the number of parameters,
\item \code{code}, a code that indicates successful convergence of the fitter function used (see nlm and optim helps),
\item \code{converged},  logical value that indicates if the optimization algorithms succesfull,
\item \code{method}, the name of the fitter function used.
}

Generic functions:

\itemize{
\item \code{print}: The print of a \code{'fitCBP'} object shows the ML parameter estimates and their standard errors in parenthesis.
\item \code{summary}: The summary provides the ML parameter estimates, their standard errors and the statistic and p-value of the Wald test to check if the parameters are significant.
This summary also shows the loglikelihood, AIC and BIC values, as well as the results for the chi-squared goodness-of-fit test and the Kolmogorov-Smirnov test for discrete variables. Finally, the correlation matrix between parameter estimates appears.
\item \code{coef}: It extracts the fitted coefficients from a \code{'fitCBP'} object.
\item \code{logLik}: It extracts the estimated log-likelihood from a \code{'fitCBP'} object.
\item \code{AIC}: It extracts the value of the Akaike Information Criterion from a \code{'fitCBP'} object.
\item \code{BIC}: It extracts the value of the Bayesian Information Criterion from a \code{'fitCBP'} object.
\item \code{plot}: It shows the plot of a \code{'fitCBP'} object. Observed and theoretical probabilities, empirical and theoretical cumulative distribution functions or empirical cumulative probabilities against theoretical cumulative probabilities are the three plot types.
}
}
\description{
Maximum-likelihood fitting of the Complex Biparametric Pearson (CBP) distribution with parameters \eqn{b} and \eqn{\gamma}. Generic
methods are \code{print}, \code{summary}, \code{coef}, \code{logLik}, \code{AIC}, \code{BIC} and \code{plot}.
}
\details{
If the starting values of the parameters \eqn{b} and \eqn{\gamma} are omitted (default option), 
they are computing by the method of moments (if possible; otherwise they must be entered).

The default method is \code{"L-BFGS-B"} (see details in \code{\link{optim}} function),
but non-linear minimization (\code{\link{nlm}}) or those included in the \code{optim} function (\code{"Nelder-Mead"}, 
\code{"BFGS"}, \code{"CG"} and \code{"SANN"}) may be used.

Standard error (SE) estimates for \eqn{b} and \eqn{\gamma} are provided by the default method; 
otherwise, SE for \eqn{\gamma_0} where \eqn{\gamma=exp{(\gamma_0})} is computed.
}
\examples{
set.seed(123)
x <- rcbp(500, 1.75, 3.5)
fitcbp(x)
summary(fitcbp(x, bstart = 1.1, gammastart = 3))
}
\references{
\insertRef{RCS2003}{cpd}
}
\seealso{
Plot of observed and theoretical frequencies for a CBP fit: \code{\link{plot.fitCBP}}

Maximum-likelihood fitting for the CTP distribution: \code{\link{fitctp}}.

Maximum-likelihood fitting for the EBW distribution: \code{\link{fitebw}}.
}
