% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/covafill.R
\docType{class}
\name{covafill-class}
\alias{covafill}
\alias{covafill-class}
\title{A Reference Class for Local Polynomial Regression with covafill.}
\description{
A Reference Class for Local Polynomial Regression with covafill.
}
\section{Fields}{

\describe{
\item{\code{ptr}}{External pointer to the covafill C++ object}
}}
\section{Methods}{

\describe{
\item{\code{getBandwith()}}{Get the bandwith.}

\item{\code{getDegree()}}{Get the polynomial degree.}

\item{\code{getDim()}}{Get the dimension of the coordinates.}

\item{\code{initialize(coord, obs, h = 1, p = 2L, ...)}}{Method to initialize the covafill. coord is a matrix of coordinates, obs is a vector of corresponding observations, h is a vector of bandwiths, and p is the polynomial degree.}

\item{\code{predict(coord, se.fit = FALSE)}}{Predict function value and derivatives with local polynomial regression at coord. If se.fit=TRUE a list is returned with estimates and their standard deviations.}

\item{\code{residuals(excludeRadius)}}{Get 'leave-neighborhood-out' residuals, i.e. local polynomial regression predictions excluding points within excludeRadius subtracted from the observation.}

\item{\code{setBandwith(h)}}{Set the bandwith to h.}
}}
\examples{
getRefClass('covafill')
fn <- function(x) x ^ 4 - x ^ 2
x <- runif(2000,-3,3)
y <- fn(x) + rnorm(2000,0,0.1)
cf <- covafill(coord = x,obs = y,h = 0.5,p = 3L)
cf$getDim()
cf$getDegree()
cf$getBandwith()
cf$setBandwith(1.0)
cf$getBandwith()
x0 <- seq(-1,1,0.1)
y0 <- cf$predict(x0)
par(mfrow=c(3,1))
plot(x0,y0[,1], main = "Function")
lines(x0,fn(x0))
plot(x0, y0[,2], main = "First derivative")
lines(x0, 4 * x0 ^ 3 - 2 * x0)
plot(x0, y0[,3], main = "Second derivative")
lines(x0, 3 * 4 * x0 ^ 2 - 2)
}

