% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structureCovariances.R
\name{structureCovariances}
\alias{structureCovariances}
\title{Structure of a Covariance Matrix Test}
\usage{
structureCovariances(x, Sigma, ..., covTest = Nagao1973)
}
\arguments{
\item{x}{data}

\item{Sigma}{Population covariance matrix}

\item{...}{other options passed to covTest method}

\item{covTest}{structure of covariance matrix test method}
}
\value{
A list with class "htest" containing the following components:

\tabular{ll}{
\code{statistic} \tab the value of equality of covariance test statistic \cr
\tab \cr
\code{parameter} \tab the degrees of freedom for the chi-squared statistic \cr
\tab \cr
\code{p.value} \tab the p=value for the test \cr
\tab \cr
\code{estimate} \tab the estimated covariances if less than 5 dimensions \cr
\tab \cr
\code{null.value} \tab the specified hypothesized value of the covariance difference \cr
\tab \cr
\code{alternative} \tab a character string describing the alternative hyposthesis \cr
\tab \cr
\code{method} \tab a character string indicating what type of equality of covariance test was performed \cr
\tab \cr
\code{data.name} \tab a character string giving the names of the data
}
}
\description{
Performs a structure of a covariance matrix test.
}
\details{
The \code{\link{structureCovariances}} function is a wrapper function that formats the data 
  for the specific \code{covTest} functions.
}
