% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosinor2.R
\name{population.cosinor.lm}
\alias{population.cosinor.lm}
\title{Population-Mean Cosinor}
\usage{
population.cosinor.lm(firstsubj, lastsubj, timecol, period, data, na.action)
}
\arguments{
\item{firstsubj}{Column number of the first subject in the data frame.}

\item{lastsubj}{Column number of the last subject in the data frame.}

\item{timecol}{Column number of the column containing the time data in the data frame.}

\item{period}{Duration of one cycle of rhythm.}

\item{data}{data frame containing all the subjects and time data.}

\item{na.action}{Action to be performed on missing values.}
}
\value{
A list containing following objects:
 \item{\code{single.cos}}{A list of objects containing all performed single cosinors.}
 \item{\code{pop.mat}}{A data frame containing the cosinor parameters of each subject in the population.}
 \item{\code{coefficients}}{Delinearized population-mean cosinor coefficients.}
 \item{\code{emp.mean}}{Empirical mean of the data across all timepoints.}
 \item{\code{fitted.values}}{Estimated values of the rhythm caclculated using the cosinor model.}
 \item{\code{residuals}}{The difference between empirical mean and the fitted values.}
}
\description{
Calculates the population-mean cosinor.
}
\details{
According to the procedure described in Cornélissen (2014), to calculate population-mean cosinor, single cosinors are first performed on each subject and linearized parameters are averaged, which allows for calculation of delinearized parameters.
}
\examples{
population.cosinor.lm(timecol = 1, firstsubj = 2, lastsubj = 20, data = PANAS_november,
period = 7, na.action = "na.exclude")
}
\references{
Cornélissen, G. (2014). Cosinor-Based Rhythmometry. \emph{Theoretical Biology and Medical Modeling}, \emph{11}, Article 16.
}
