% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsea.R
\name{gsea}
\alias{gsea}
\title{GSEA}
\usage{
gsea(
  reflist,
  set,
  method = c("permutation", "pareto"),
  np = 1000,
  w = 1,
  gsea_null = NULL
)
}
\arguments{
\item{reflist}{named vector of reference scores}

\item{set}{element set}

\item{method}{one of 'permutation' or 'pareto'}

\item{np}{Number of permutations (Default: 1000)}

\item{w}{exponent used to raise the supplied scores. Default is 1 (original
scores unchanged)}

\item{gsea_null}{a GSEA null distribution (Optional)}
}
\value{
A GSEA object. Basically a list of s components:
\describe{
\item{ES}{The enrichment score}
\item{NES}{The normalized enrichment socre}
\item{ledge}{The items in the leading edge}
\item{p.value}{The permutation-based p-value}
}
}
\description{
This function performs Gene Set Enrichment Analysis
}
\examples{
reflist<-setNames(-sort(rnorm(1000)),paste0('gene',1:1000))
set<-paste0('gene',sample(1:200,50))
obj<-gsea(reflist,set,method='pareto',np=1000)
obj$p.value
}
