% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_to_ci.R, R/cor_to_p.R
\name{cor_to_ci}
\alias{cor_to_ci}
\alias{cor_to_p}
\title{Convert correlation to p-values and CIs}
\usage{
cor_to_ci(cor, n, ci = 0.95, method = "pearson")

cor_to_p(cor, n, method = "pearson")
}
\arguments{
\item{cor}{A correlation matrix or coefficient.}

\item{n}{The sample size (number of observations).}

\item{ci}{Confidence/Credible Interval level. If "default", then 0.95 for Frequentist and 0.89 for Bayesian (see documentation in the \pkg{bayestestR} package).}

\item{method}{A character string indicating which correlation coefficient is to be used for the test. One of "pearson" (default), "kendall", or "spearman", "biserial", "polychoric", "tetrachoric", "biweight", "distance", "percentage" (for percentage bend correlation) or "shepherd" (for Shepherd's Pi correlation). Setting "auto" will attempt at selecting the most relevant method (polychoric when ordinal factors involved, tetrachoric when dichotomous factors involved, point-biserial if one dichotomous and one continuous and pearson otherwise).}
}
\value{
A list containing a p-value and the statistic or the CI bounds.
}
\description{
Get statistics, p-values and confidence intervals (CI) from correlation coefficients.
}
\examples{
cor.test(iris$Sepal.Length, iris$Sepal.Width)
cor_to_p(-0.1175698, n = 150)
cor_to_p(cor(iris[1:4]), n = 150)
cor_to_ci(-0.1175698, n = 150)
cor_to_ci(cor(iris[1:4]), n = 150)

cor.test(iris$Sepal.Length, iris$Sepal.Width, method = "spearman")
cor_to_p(-0.1667777, n = 150, method = "spearman")
cor_to_ci(-0.1667777, ci = 0.95, n = 150)

cor.test(iris$Sepal.Length, iris$Sepal.Width, method = "kendall")
cor_to_p(-0.07699679, n = 150, method = "kendall")
}
