% Generated by roxygen2 (4.0.2): do not edit by hand
\name{cint.corregp}
\alias{cint}
\alias{cint.corregp}
\title{Confidence Intervals for Correspondence Regression}
\usage{
\method{cint}{corregp}(object, parm = "x", axis, cl = 0.95, nq = TRUE,
  ...)

cint(object, ...)
}
\arguments{
\item{object}{The output of a call to \code{\link{corregp}} (i.e. an object of class "corregp").}

\item{parm}{The parameter for which to compute the confidence intervals. Can be either \code{"y"}, \code{"x"}, or any vector of term names in X, level names in X or
level names in Y. Defaults to \code{"x"}.}

\item{axis}{The axis for which to compute the confidence intervals.}

\item{cl}{The confidence level for the confidence interval. Defaults to \code{0.95}.}

\item{nq}{Logical specifying whether to use a normal quantile (i.e. apply \code{\link[stats]{qnorm}}) in the computation of the confidence intervals.}

\item{...}{Further arguments passed to or from other methods.
Defaults to \code{TRUE}. If \code{FALSE}, then the confidence intervals are computed directly with the \code{\link[stats]{quantile}} function.}
}
\value{
A matrix with \code{Lower} and \code{Upper} confidence limits for the coordinates of interest.
}
\description{
Method to compute confidence intervals for coordinates in correspondence regression.
}
\details{
\code{cint} (of a \code{corregp} output) makes use of \code{\link{ci}}.

Typically, \code{cint} is not so much used directly as it is called by a \code{\link{ciplot.corregp}} command.
}
\examples{
data(HairEye)
haireye.crg <- corregp(Eye ~ Hair * Sex, data = HairEye, b = 3000)
cint(haireye.crg, parm = "y", axis = 1)
cint(haireye.crg, parm = c("Hair", "Sex"), axis = 1)
}
\seealso{
\code{\link{ci}}, \code{\link{ciplot.corregp}}.
}

