% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr2d_plot.R
\name{plot_corr2din3d}
\alias{plot_corr2din3d}
\title{3D plot of two-dimensional correlation spectra.}
\usage{
plot_corr2din3d(Mat, specx = NULL, specy = NULL, scalex = NULL,
  scaley = NULL, Col = colorspace::diverge_hcl(64, h = c(240, 0), c =
  100, l = c(20, 100), power = 0.4), reduce = NULL, zlim = NULL,
  projection = FALSE, ...)
}
\arguments{
\item{Mat}{Real numeric matrix containing the z-values to plot.}

\item{specx, specy}{Numeric vector containing the data, that will be
plotted at the x and y axis. Can be any data and does not need to have
the same dimensions as \code{Mat}.}

\item{scalex, scaley}{A real number which describes how \code{specx}
(or \code{specy}) get scaled. Positive numbers lead to a spectrum
plotted inside the box, while negative numbers lead to a spectrum
plotted outside the box.}

\item{Col}{Vector containing colors used to plot the 3D plot and the
respective projection.}

\item{reduce}{Non-zero rational number describing how to
\code{\link[mmand]{resample}} the data values. Can reduce the 
computational demand and can be used for fast previews.}

\item{zlim}{Numeric vector with two values indicating the z-range of
the 3D plot.}

\item{projection}{Logical: Should a 2D projection of the 3D surface
be plotted a the bottom of the box?}

\item{...}{Additional arguments passed to \code{\link[fields]{drape.plot}}.}
}
\description{
\code{plot_corr2din3d} plots two-dimensional correlation spectra as an 3D surface.
}
\details{
For the synchronous correlation spectrum the real component (\code{Re})
    of the complex correlation matrix must be plotted. The asynchronous
    spectrum is the respective imaginary component (\code{Im}).
}
\examples{
   data(FuranMale, package = "corr2D")
   twod <- corr2d(FuranMale, Ref1 = FuranMale[1, ], corenumber = 1)
   
   plot_corr2din3d(Mat = Re(twod$FT), specx = twod$Ref1,
       specy = twod$Ref1, reduce = 2, scalex = -175, scaley = -175,
       zlim = c(-1.5, 2.2)*10^-3, projection = FALSE,
       border = gray(0.2), theta = 25, phi = 15, add.legend = FALSE,
       Col = fields::tim.colors(64))
   
}
\references{
R. Geitner et al. (2019) <DOI:10.18637/jss.v090.i03>
}
\seealso{
See \code{\link{plot_corr2d}} for 2D plots.
    See \code{\link[fields]{drape.plot}} for information on the plot function.
}
