% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_text.r
\name{browse_hits}
\alias{browse_hits}
\title{View hits in a browser}
\usage{
browse_hits(tc, hits, token_col = "token", n = 500,
  select = c("first", "random"), header = "", subheader = NULL,
  meta_cols = NULL, seed = NA, view = T, filename = NULL)
}
\arguments{
\item{tc}{a tCorpus}

\item{hits}{a featureHits object, as returned by \link{search_features}}

\item{token_col}{The name of the column in tc$tokens that contain the token text}

\item{n}{If doc_ids is NULL, Only n of the results are printed (to prevent accidentally making huge browsers).}

\item{select}{If n is smaller than the number of documents in tc, select determines how the n documents are selected}

\item{header}{Optionally, a title presented at the top of the browser}

\item{subheader}{Optionally, overwrite the subheader. By default the subheader reports the number of documents}

\item{meta_cols}{A character vector with names of columns in tc$meta, used to only show the selected columns}

\item{seed}{If select is "random", seed can be used to set a random seed}

\item{view}{If TRUE (default), view the browser in the Viewer window (turn off if this is not supported)}

\item{filename}{Optionally, save the browser at a specified location}
}
\value{
The url for the file location is returned (invisibly)
}
\description{
Creates a static HTML file to view the query hits in the tcorpus in full text mode.
}
\examples{
\donttest{
tc = create_tcorpus(sotu_texts, doc_column='id')
hits = search_features(tc, c("Terrorism# terroris*", "War# war*"))
browse_hits(tc, hits)
}
}
