% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_information.r
\name{tCorpus$top_features}
\alias{tCorpus$top_features}
\alias{top_features}
\title{Show top features}
\arguments{
\item{feature}{The name of the feature}

\item{n}{Return the top n features}

\item{group_by}{A column in the token data to group the top features by. For example, if token data contains part-of-speech tags (pos), then grouping by pos will show the top n feature per part-of-speech tag.}

\item{group_by_meta}{A column in the meta data to group the top features by.}

\item{return_long}{if True, results will be returned in a long format. Default is a table, but this can be inconvenient if there are many grouping variables.}
}
\description{
\strong{Usage:}
}
\details{
## R6 method for class tCorpus. Use as tc$method (where tc is a tCorpus object).

\preformatted{top_features(feature, n = 10, group_by = NULL, group_by_meta = NULL, return_long = F}
}
\examples{
tc = tokens_to_tcorpus(corenlp_tokens, token_id_col = 'id')

tc$top_features('lemma')
tc$top_features('lemma', group_by = 'relation')
}
