/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter.objectives;

import java.util.Set;
import org.corehunter.data.CoreHunterData;
import org.corehunter.data.FrequencyGenotypeData;
import org.corehunter.exceptions.CoreHunterException;
import org.corehunter.objectives.eval.HeterozygousLociEvaluation;
import org.jamesframework.core.exceptions.IncompatibleDeltaEvaluationException;
import org.jamesframework.core.problems.objectives.Objective;
import org.jamesframework.core.problems.objectives.evaluations.Evaluation;
import org.jamesframework.core.search.neigh.Move;
import org.jamesframework.core.subset.SubsetSolution;
import org.jamesframework.core.subset.neigh.moves.SubsetMove;

public class HeterozygousLoci
implements Objective<SubsetSolution, CoreHunterData> {
    public HeterozygousLociEvaluation evaluate(SubsetSolution solution, CoreHunterData data) {
        FrequencyGenotypeData geno = data.getGenotypicData();
        if (geno == null) {
            throw new CoreHunterException("Genotypes are required for expected proportion of heterozygous loci objective.");
        }
        return new HeterozygousLociEvaluation(solution.getSelectedIDs(), geno);
    }

    public HeterozygousLociEvaluation evaluate(Move move, SubsetSolution curSolution, Evaluation curEvaluation, CoreHunterData data) {
        if (!(move instanceof SubsetMove)) {
            throw new IncompatibleDeltaEvaluationException("Heterozygous loci objective should be used in combination with neighbourhoods that generate moves of type SubsetMove.");
        }
        SubsetMove subsetMove = (SubsetMove)move;
        HeterozygousLociEvaluation eval = (HeterozygousLociEvaluation)curEvaluation;
        Set<Integer> added = subsetMove.getAddedIDs();
        Set<Integer> deleted = subsetMove.getDeletedIDs();
        return new HeterozygousLociEvaluation(eval, added, deleted, data.getGenotypicData());
    }

    @Override
    public boolean isMinimizing() {
        return false;
    }

    public String toString() {
        return "Expected proportion of heterozygous loci";
    }
}

