% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerstress.R
\name{plot.smacofP}
\alias{plot.smacofP}
\title{S3 plot method for smacofP objects}
\usage{
\method{plot}{smacofP}(
  x,
  plot.type = "confplot",
  plot.dim = c(1, 2),
  bubscale = 5,
  col,
  label.conf = list(label = TRUE, pos = 3, col = 1, cex = 0.8),
  identify = FALSE,
  type = "p",
  pch = 20,
  asp = 1,
  main,
  xlab,
  ylab,
  xlim,
  ylim,
  legend = TRUE,
  legpos,
  loess = TRUE,
  ...
)
}
\arguments{
\item{x}{an object of class smacofP}

\item{plot.type}{String indicating which type of plot to be produced: "confplot", "resplot", "Shepard", "stressplot","transplot", "bubbleplot" (see details)}

\item{plot.dim}{dimensions to be plotted in confplot; defaults to c(1, 2)}

\item{bubscale}{Scaling factor (size) for the bubble plot}

\item{col}{vector of colors for the points}

\item{label.conf}{List with arguments for plotting the labels of the configurations in a configuration plot (logical value whether to plot labels or not, label position, label color)}

\item{identify}{If 'TRUE', the 'identify()' function is called internally that allows to add configuration labels by mouse click}

\item{type}{What type of plot should be drawn (see also 'plot')}

\item{pch}{Plot symbol}

\item{asp}{Aspect ratio; defaults to 1 so distances between x and y are represented accurately; can lead to slighlty weird looking plots if the variance on one axis is much smaller than on the other axis; use NA if the standard type of R plot is wanted where the ylim and xlim arguments define the aspect ratio - but then the distances seen are no longer accurate}

\item{main}{plot title}

\item{xlab}{label of x axis}

\item{ylab}{label of y axis}

\item{xlim}{scale of x axis}

\item{ylim}{scale of y axis}

\item{legend}{Flag whether legends should be drawn for plots that have legends}

\item{legpos}{Position of legend in plots with legends}

\item{loess}{should loess fit be added to Shepard plot}

\item{...}{Further plot arguments passed: see 'plot.smacof' and 'plot' for detailed information.

Details:
\itemize{
\item  Configuration plot (plot.type = "confplot"): Plots the MDS configurations.
 \item Residual plot (plot.type = "resplot"): Plots the dissimilarities against the fitted distances.
 \item Linearized Shepard diagram (plot.type = "Shepard"): Diagram with the transformed observed dissimilarities against the transformed fitted distance as well as loess curve and a least squares line.
 \item Transformation Plot (plot.type = "transplot"): Diagram with the observed dissimilarities (lighter) and the transformed observed dissimilarities (darker) against the fitted distances together with the nonlinear regression curve 
 \item Stress decomposition plot (plot.type = "stressplot"): Plots the stress contribution in of each observation. Note that it rescales the stress-per-point (SPP) from the corresponding smacof function to percentages (sum is 100). The higher the contribution, the worse the fit.
 \item Bubble plot (plot.type = "bubbleplot"): Combines the configuration plot with the point stress contribution. The larger the bubbles, the better the fit.
}}
}
\description{
S3 plot method for smacofP objects
}
\examples{
dis<-as.matrix(smacof::kinshipdelta)
res<-powerStressMin(dis)
plot(res)
plot(res,"reachplot")
plot(res,"Shepard")
plot(res,"resplot")
plot(res,"transplot")
plot(res,"stressplot")
plot(res,"bubbleplot")
}
