% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convoSPAT_paramEst.R
\name{make_aniso_loglik}
\alias{make_aniso_loglik}
\title{Constructor functions for local parameter estimation.}
\usage{
make_aniso_loglik(locations, cov.model, data, Xmat, nugg2.var)
}
\arguments{
\item{locations}{A matrix of locations.}

\item{cov.model}{String; the covariance model.}

\item{data}{A vector or matrix of data to use in the likelihood
calculation.}

\item{Xmat}{The design matrix for the mean model.}

\item{nugg2.var}{Fixed values for the variance of the second nugget term.}
}
\value{
This function returns another function for use in \code{optim}.
}
\description{
This function generates another function to be used within \code{optim} to
obtain maximum likelihood estimates of
local variance parameters lam1, lam2, eta, tausq, and sigmasq,
assuming the smoothness is fixed, using a Gaussian likelihood with
an anisotropic covariance structure.
}
\examples{
\dontrun{
make_aniso_loglik( locations, cov.model, data, Xmat )
}

}

