% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convoSPAT_summplot.R
\name{evaluate_CV}
\alias{evaluate_CV}
\title{Evaluation criteria}
\usage{
evaluate_CV(holdout.data, pred.mean, pred.SDs)
}
\arguments{
\item{holdout.data}{Observed/true data that has been held out for model
comparison.}

\item{pred.mean}{Predicted mean values corresponding to the hold-out
locations.}

\item{pred.SDs}{Predicted standard errors corresponding to the hold-out
locations.}
}
\value{
A list with the following components:
\item{CRPS}{The CRPS averaged over all hold-out locations.}
\item{MSPE}{The mean squared prediction error.}
\item{pMSDR}{The prediction mean square deviation ratio.}
}
\description{
Calculate three evaluation criteria -- continuous rank probability score
(CRPS), prediction mean square deviation ratio (pMSDR), and mean squared prediction
error (MSPE) -- comparing hold-out data and predictions.
}
\examples{
\dontrun{
evaluate_CV( holdout.data = simdata$sim.data[holdout.index],
pred.mean = pred.NS$pred.means, pred.SDs = pred.NS$pred.SDs )
}

}

