% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/the_rx2_table.R
\name{the_rx2_table}
\alias{the_rx2_table}
\title{The rx2 table}
\usage{
the_rx2_table(n, alpha = 0.05, direction = "increasing", skip_exact = FALSE)
}
\arguments{
\item{n}{the total number of observations}

\item{alpha}{the nominal level, e.g. 0.05 for 95\% CIs}

\item{direction}{the direction of the success probabilities}

\item{skip_exact}{If \code{FALSE}, skips the exact conditional and mid-P tests
for unspecific ordering (often saves calculation time)
("increasing" or "decreasing")}
}
\value{
A string of "-". This function should be called for its printed output.
}
\description{
The rx2 table
}
\examples{
\dontrun{

# Alcohol consumption and malformations (Mills and Graubard, 1987)
n.0 <- rbind(c(48, 17066), c(38, 14464), c(5, 788), c(1, 126), c(1, 37))
a.0 <- c(1, 2, 3, 4, 5)
the_rx2_table(n.0, a.0, "increasing")


# Elevated troponin T levels in stroke patients (Indredavik et al., 2008)
n.1 <- rbind(c(8, 53), c(10, 48), c(11, 100), c(22, 102), c(6, 129))
a.1 <- c(7, 22, 37, 48, 55)
the_rx2_table(n.1, a.1, "decreasing")
}
}
