% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PriceBonett_approximate_Bayes_CI_2x2.R
\name{PriceBonett_approximate_Bayes_CI_2x2}
\alias{PriceBonett_approximate_Bayes_CI_2x2}
\title{The Price-Bonett approximate Bayes confidence interval for the ratio of probabilities}
\usage{
PriceBonett_approximate_Bayes_CI_2x2(
  n,
  a = 1.25,
  b = 2.5,
  alpha = 0.05,
  printresults = TRUE
)
}
\arguments{
\item{n}{the observed counts (a 2x2 matrix)}

\item{a, b}{parameters of the beta distribution}

\item{alpha}{the nominal level, e.g. 0.05 for 95# CIs}

\item{printresults}{display results (0 = no, 1 = yes)}
}
\value{
A data frame containing lower, upper and point estimates of the statistic
}
\description{
The Price-Bonett approximate Bayes confidence interval for the ratio of probabilities

Described in Chapter 4 "The 2x2 Table"
}
\examples{
# An RCT of high vs standard dose of epinephrine (Perondi et al., 2004)
n <- matrix(c(7, 27, 1, 33), nrow=2, byrow=TRUE)
PriceBonett_approximate_Bayes_CI_2x2(n)

# The association between CHRNA4 genotype and XFS (Ritland et al., 2007)
n <- matrix(c(0, 16, 15, 57), nrow=2, byrow=TRUE)
PriceBonett_approximate_Bayes_CI_2x2(n)

}
