% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_mab_epsilon_first.R
\name{EpsilonFirstPolicy}
\alias{EpsilonFirstPolicy}
\title{Policy: Epsilon First}
\description{
\code{EpsilonFirstPolicy} implements a "naive" policy where a pure exploration phase
is followed by a pure exploitation phase.
}
\details{
Exploration happens within the first \code{epsilon * N} time steps.
During this time, at each time step \code{t}, \code{EpsilonFirstPolicy} selects an arm at random.

Exploitation happens in the following \code{(1-epsilon) * N} steps,
selecting the best arm up until \code{epsilon * N} for either the remaining N trials or horizon T.

In case of a tie in the exploitation phase, \code{EpsilonFirstPolicy} randomly selects and arm.
}
\section{Usage}{

\preformatted{
policy <- EpsilonFirstPolicy(epsilon = 0.1, N = 1000, time_steps = NULL)
}
}

\section{Arguments}{


\describe{
\item{\code{epsilon}}{
numeric; value in the closed interval \code{(0,1]} that sets the number of time steps to explore
through \code{epsilon * N}.
}
\item{\code{N}}{
integer; positive integer which sets the number of time steps to explore through \code{epsilon * N}.
}
\item{\code{time_steps}}{
integer; positive integer which sets the number of time steps to explore - can be used instead of
epsilon and N.
}
}
}

\section{Methods}{


\describe{
\item{\code{new(epsilon = 0.1, N = 1000, time_steps = NULL)}}{ Generates a new \code{EpsilonFirstPolicy}
object. Arguments are defined in the Argument section above.}
}

\describe{
\item{\code{set_parameters()}}{each policy needs to assign the parameters it wants to keep track of
to list \code{self$theta_to_arms} that has to be defined in \code{set_parameters()}'s body.
The parameters defined here can later be accessed by arm index in the following way:
\code{theta[[index_of_arm]]$parameter_name}
}
}

\describe{
\item{\code{get_action(context)}}{
here, a policy decides which arm to choose, based on the current values
of its parameters and, potentially, the current context.
}
}

\describe{
\item{\code{set_reward(reward, context)}}{
in \code{set_reward(reward, context)}, a policy updates its parameter values
based on the reward received, and, potentially, the current context.
}
}
}

\examples{

horizon            <- 100L
simulations        <- 100L
weights            <- c(0.9, 0.1, 0.1)

policy             <- EpsilonFirstPolicy$new(time_steps = 50)
bandit             <- BasicBernoulliBandit$new(weights = weights)
agent              <- Agent$new(policy, bandit)

history            <- Simulator$new(agent, horizon, simulations, do_parallel = FALSE)$run()

plot(history, type = "cumulative")
plot(history, type = "arms")
}
\references{
Gittins, J., Glazebrook, K., & Weber, R. (2011). Multi-armed bandit allocation indices. John Wiley & Sons.
(Original work published 1989)

Sutton, R. S. (1996). Generalization in reinforcement learning: Successful examples using sparse coarse
coding. In Advances in neural information processing systems (pp. 1038-1044).

Strehl, A., & Littman, M. (2004). Exploration via model based interval estimation. In International
Conference on Machine Learning, number Icml.
}
\seealso{
Core contextual classes: \code{\link{Bandit}}, \code{\link{Policy}}, \code{\link{Simulator}},
\code{\link{Agent}}, \code{\link{History}}, \code{\link{Plot}}

Bandit subclass examples: \code{\link{BasicBernoulliBandit}}, \code{\link{ContextualLogitBandit}},
\code{\link{OfflineReplayEvaluatorBandit}}

Policy subclass examples: \code{\link{EpsilonGreedyPolicy}}, \code{\link{ContextualLinTSPolicy}}
}
