% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_mab_gittins_bl.R
\name{GittinsBrezziLaiPolicy}
\alias{GittinsBrezziLaiPolicy}
\alias{gittinsbrezzilai}
\title{Policy: Gittins Approximation algorithm for choosing arms in a MAB problem.}
\description{
\code{GittinsBrezziLaiPolicy} Algorithm based on Brezzi and Lai (2002)
"Optimal learning and experimentation in bandit problems."
}
\details{
The algorithm provides an approximation of the Gittins index, by specifying
a closed-form expression, which is a function of the discount factor, and
the number of successes and failures associated with each arm.
}
\section{Usage}{

\preformatted{
  policy <- GittinsBrezziLaiPolicy$new(discount=0.95, prior=NULL)
}
}

\section{Arguments}{


\describe{
\item{\code{discount}}{
numeric; discount factor
}
\item{\code{prior}}{
numeric matrix; prior beliefs over Bernoulli parameters governing each arm.
Beliefs are specified by Beta distribution with two parameters (alpha,beta)
where alpha = number of success, beta = number of failures.
Matrix is of arms times two (alpha / beta) dimensions
}
}
}

\section{Methods}{


\describe{
\item{\code{new(discount=0.95, prior=NULL)}}{
Generates and initializes a new \code{Policy} object.
}

\item{\code{get_action(t, context)}}{
arguments:
\itemize{
\item \code{t}: integer, time step \code{t}.
\item \code{context}: list, containing the current \code{context$X} (d x k context matrix),
\code{context$k} (number of arms) and \code{context$d} (number of context features)
}
computes which arm to play based on the current values in named list \code{theta}
and the current \code{context}. Returns a named list containing
\code{action$choice}, which holds the index of the arm to play.
}

\item{\code{set_reward(t, context, action, reward)}}{
arguments:
\itemize{
\item \code{t}: integer, time step \code{t}.
\item \code{context}: list, containing the current \code{context$X} (d x k context matrix),
\code{context$k} (number of arms) and \code{context$d} (number of context features)
(as set by \code{bandit}).
\item \code{action}:  list, containing \code{action$choice} (as set by \code{policy}).
\item \code{reward}:  list, containing \code{reward$reward} and, if available,
\code{reward$optimal} (as set by \code{bandit}).
}
utilizes the above arguments to update and return the set of parameters in list \code{theta}.
}

\item{\code{set_parameters()}}{
Helper function, called during a Policy's initialisation, assigns the values
it finds in list \code{self$theta_to_arms} to each of the Policy's k arms.
The parameters defined here can then be accessed by arm index in the following way:
\code{theta[[index_of_arm]]$parameter_name}.
}

}
}

\references{
Brezzi, M., & Lai, T. L. (2002). Optimal learning and experimentation in bandit problems. Journal of Economic Dynamics and Control, 27(1), 87-108.

Implementation follows \url{https://github.com/elarry/bandit-algorithms-simulated}
}
\seealso{
Core contextual classes: \code{\link{Bandit}}, \code{\link{Policy}}, \code{\link{Simulator}},
\code{\link{Agent}}, \code{\link{History}}, \code{\link{Plot}}

Bandit subclass examples: \code{\link{BasicBernoulliBandit}}, \code{\link{ContextualLogitBandit}},  \code{\link{OfflineReplayEvaluatorBandit}}

Policy subclass examples: \code{\link{EpsilonGreedyPolicy}}, \code{\link{ContextualThompsonSamplingPolicy}}
}
