% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrations.R
\name{p2app4conos}
\alias{p2app4conos}
\title{Utility function to generate a pagoda2 app from a conos object}
\usage{
p2app4conos(
  conos,
  cdl = NULL,
  metadata = NULL,
  filename = "conos_app.bin",
  save = TRUE,
  n.cores = 1,
  n.odgenes = 3000,
  nPcs = 100,
  k = 30,
  perplexity = 50,
  log.scale = TRUE,
  trim = 10,
  keep.genes = NULL,
  min.cells.per.gene = 0,
  min.transcripts.per.cell = 100,
  get.largevis = TRUE,
  get.tsne = TRUE,
  make.geneknn = TRUE,
  go.env = NULL,
  cell.subset = NULL,
  max.cells = Inf,
  additional.embeddings = NULL,
  test.pathway.overdispersion = FALSE,
  organism = NULL,
  return.details = FALSE
)
}
\arguments{
\item{conos}{Conos object}

\item{cdl}{list Optional list of raw matrices (so that gene merging doesn't have to be redone) (default=NULL)}

\item{metadata}{list Optional list of (named) metadata factors (default=NULL)}

\item{filename}{string Name of the *.bin file to seralize for the pagoda2 application if save=TRUE (default='conos_app.bin')}

\item{save}{boolean Save serialized *bin file specified in filename (default=TRUE)}

\item{n.cores}{integer Number of cores (default=1)}

\item{n.odgenes}{numeric Number of top overdispersed genes to use (dfault=3e3). From pagoda2::basicP2proc().}

\item{nPcs}{numeric Number of PCs to use (default=100). From pagoda2::basicP2proc().}

\item{k}{numeric Default number of neighbors to use in kNN graph (default=30). From pagoda2::basicP2proc().}

\item{perplexity}{numeric Perplexity to use in generating tSNE and largeVis embeddings (default=50). From pagoda2::basicP2proc().}

\item{log.scale}{boolean Whether to use log scale normalization (default=TRUE). From pagoda2::basicP2proc().}

\item{trim}{numeric Number of cells to trim in winsorization (default=10). From pagoda2::basicP2proc().}

\item{keep.genes}{optional set of genes to keep from being filtered out (even at low counts) (default=NULL). From pagoda2::basicP2proc().}

\item{min.cells.per.gene}{numeric Minimal number of cells required for gene to be kept (unless listed in keep.genes) (default=0). From pagoda2::basicP2proc().}

\item{min.transcripts.per.cell}{numeric Minimumal number of molecules/reads for a cell to be admitted (default=100). From pagoda2::basicP2proc().}

\item{get.largevis}{boolean Whether to caluclate largeVis embedding (default=TRUE). From pagoda2::basicP2proc().}

\item{get.tsne}{boolean Whether to calculate tSNE embedding (default=TRUE). From pagoda2::basicP2proc().}

\item{make.geneknn}{boolean Whether pre-calculate gene kNN (for gene search) (default=TRUE). From pagoda2::basicP2proc().}

\item{go.env}{GO environment for the organism of interest (default=NULL)}

\item{cell.subset}{string Cells to subset with the conos embedding conos$embedding. If NULL, uses all cells via rownames(conos$embedding) (default=NULL)}

\item{max.cells}{numeric Limit to the cells that are included in the conos. If Inf, there is no limit (default=Inf)}

\item{additional.embeddings}{list Additional embeddings to add to conos for the pagoda2 app (default=NULL)}

\item{test.pathway.overdispersion}{boolean Find all IDs using GO category against either org.Hs.eg.db ('hs') or org.Mm.eg.db ('mm') (default=FALSE}

\item{organism}{string Organism of interest, either 'hs' (Homo sapiens) or 'mm' (Mus musculus, i.e. mouse) (default=NULL). Only used if test.pathway.overdispersion is TRUE. If NULL and test.pathway.overdispersion=TRUE, then 'hs' is used.}

\item{return.details}{boolean If TRUE, return list of p2 application, pagoda2 object, list of raw matrices, and cell names. If FALSE, simply return pagoda2 app object. (default=FALSE)}
}
\value{
pagoda2 app object
}
\description{
Utility function to generate a pagoda2 app from a conos object
}
