% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFunctions_1_0_2.r
\name{apply.scope}
\alias{apply.scope}
\title{Function to subset the output table from balance() or diagnose() to covariate balance metrics at a certain distance (e.g. a certain recency) or produce estimates that average over person-time.}
\usage{
apply.scope(input, diagnostic, approach, scope = "all",
  average.over = NULL, periods = NULL, list.distance = NULL,
  recency = NULL, sort.order = "alphabetical",
  ignore.missing.metric = "no", metric = "SMD")
}
\arguments{
\item{input}{dataframe output by diagnose() or balance() function}

\item{diagnostic}{diagnostic of interest e.g. 1, 2, or 3}

\item{approach}{adjustment method e.g. "none" or "weight" or "stratify"}

\item{scope}{report the entire trellis e.g. "all", the diagonal e.g. "recent", or a summary e.g. "average"}

\item{average.over}{summary level for average metrics e.g. standardize over "values" or "history" or "time" or "distance"}

\item{periods}{a list of contiguous segments of relative distance to pool over e.g. list(0,1:4,5:10) would yield summaries over three segments}

\item{list.distance}{a vector of distances to retain after averaging over time e.g. c(0,2)}

\item{recency}{an integer for the relative distance between exposures and covariate measurements to focus on (e.g. 0 would represent the same timing). The default is 0 for Diagnostics 1 and 3, and 1 for Diagnostic 2}

\item{sort.order}{vector of root names for all covariates listed in the order in which they should appear in the table (and also plot) e.g. c("n","m","o","l","p"). To display covariates in alphabetical order (the default), leave blank or type "alphabetical"}

\item{ignore.missing.metric}{"yes" or "no" depending on whether the user wishes to estimate averages over person-time when there are missing values of the mean difference or standardized mean difference. Missing values for the standardized mean difference can occur when, for example, there is no covariate variation within levels of exposure-history and measurement times. If this argument is set to "no" and there are missing values, the average will also be missing. If set to "yes" an average will be produced that ignores missing values.}

\item{metric}{the metric for which the user wishes to ignore missing values as specified in the 'ignore.missing.metric' argument.}
}
\value{
A covariate balance table. See the \code{balance()} function for details.
}
\description{
Function to subset the output table from balance() or diagnose() to covariate balance metrics at a certain distance (e.g. a certain recency) or produce estimates that average over person-time.
}
\details{
In most cases this helper function will not be needed by the user, unless omit.history() is called after diagnose() with scope="all" and one desires to subsequently average metris over time or distance. When using the balance() , diagnose(), or  apply.scope() functions, specifying average.over="average" and average.over="time" will return balance metrics for each "distance" value. The output can be subset to specific distances of interest e.g. k=0 and k=2 by supplying a vector to list.distance e.g. c(0,2) but this is optional. Specifying average.over="distance", you can opt to average within segments of distance using the periods argument (leaving this blank will average over all distance values). The periods argument requires a list of contiguous numeric vectors e.g. list(0,1:4,5:10). For Diagnostic 3 this would report metrics at time t, averages over times t-1 to t-4, and averages over times t-5 to t-10. For Diagnostics 1 and 3 the entire range should lie between 0 and t. For Diagnostic 2 the entire range should lie between 1 and t.
}
